/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletInfo;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import org.arquillian.undertow.UndertowContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.undertow.api.UndertowHttpHandlerArchive;
import org.jboss.shrinkwrap.undertow.api.UndertowWebArchive;

public class EmbeddedUndertowContainer
implements DeployableContainer<UndertowContainerConfiguration> {
    private Undertow undertow;
    private UndertowContainerConfiguration configuration;
    private DeploymentManager deploymentManager;

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        HTTPContext httpContext = null;
        if (archive instanceof UndertowWebArchive) {
            httpContext = this.registerDeploymentInfo(archive);
        } else if (archive instanceof UndertowHttpHandlerArchive) {
            httpContext = this.registerHandler(archive);
        }
        return new ProtocolMetaData().addContext((Object)httpContext);
    }

    private HTTPContext registerHandler(Archive<?> archive) {
        UndertowHttpHandlerArchive handler = (UndertowHttpHandlerArchive)archive;
        this.undertow = this.createUndertow(handler.getHttpHandler());
        this.undertow.start();
        HTTPContext httpContext = new HTTPContext(this.configuration.getBindAddress(), this.configuration.getBindHttpPort());
        return httpContext;
    }

    private HTTPContext registerDeploymentInfo(Archive<?> archive) {
        UndertowWebArchive servletBuilder = (UndertowWebArchive)archive;
        DeploymentInfo deploymentInfo = servletBuilder.getDeploymentInfo();
        this.deploymentManager = Servlets.defaultContainer().addDeployment(deploymentInfo);
        this.deploymentManager.deploy();
        try {
            this.undertow = this.createUndertow(this.deploymentManager.start());
            this.undertow.start();
        }
        catch (ServletException e) {
            throw new IllegalArgumentException(e);
        }
        HTTPContext httpContext = new HTTPContext(this.configuration.getBindAddress(), this.configuration.getBindHttpPort());
        Map servlets = deploymentInfo.getServlets();
        Collection servletsInfo = servlets.values();
        for (ServletInfo servletInfo : servletsInfo) {
            httpContext.add(new Servlet(servletInfo.getName(), this.deploymentManager.getDeployment().getDeploymentInfo().getContextPath()));
        }
        return httpContext;
    }

    private Undertow createUndertow(HttpHandler handler) {
        return Undertow.builder().setHandler(handler).addHttpListener(this.configuration.getBindHttpPort(), this.configuration.getBindAddress()).build();
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Class<UndertowContainerConfiguration> getConfigurationClass() {
        return UndertowContainerConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.1");
    }

    public void setup(UndertowContainerConfiguration undertowContainerConfiguration) {
        this.configuration = undertowContainerConfiguration;
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        if (this.deploymentManager != null) {
            try {
                this.deploymentManager.stop();
            }
            catch (ServletException e) {
                throw new DeploymentException(e.getMessage());
            }
        }
        this.undertow.stop();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

