/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.configuration;

import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.AndroidDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.CapabilityMap;
import org.jboss.arquillian.drone.webdriver.configuration.ChromeDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.FirefoxDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.HtmlUnitDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.IPhoneDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.InternetExplorerDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.RemoteReusableWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfigurationType;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedWebDriverConfiguration<T extends WebDriverConfigurationType>
implements DroneConfiguration<TypedWebDriverConfiguration<T>>,
AndroidDriverConfiguration,
ChromeDriverConfiguration,
FirefoxDriverConfiguration,
HtmlUnitDriverConfiguration,
InternetExplorerDriverConfiguration,
IPhoneDriverConfiguration,
WebDriverConfiguration,
RemoteReusableWebDriverConfiguration {
    private static final Logger log = Logger.getLogger(TypedWebDriverConfiguration.class.getName());
    public static final String CONFIGURATION_NAME = "webdriver";
    public static URL DEFAULT_REMOTE_URL;
    public static final String DEFAULT_BROWSER_CAPABILITIES;
    protected Class<T> type;
    @Deprecated
    protected String implementationClass;
    protected int iePort;
    @Deprecated
    protected String applicationName;
    @Deprecated
    protected String applicationVersion;
    @Deprecated
    protected String userAgent;
    @Deprecated
    protected String firefoxProfile;
    @Deprecated
    protected String firefoxBinary;
    @Deprecated
    protected String chromeBinary;
    protected String chromeDriverBinary;
    @Deprecated
    protected String chromeSwitches;
    protected URL remoteAddress;
    @Deprecated
    protected float browserVersionNumeric;
    @Deprecated
    protected boolean useJavaScript = true;
    @Deprecated
    protected String operaArguments;
    @Deprecated
    protected boolean operaAutostart = true;
    @Deprecated
    protected String operaBinary;
    @Deprecated
    protected int operaDisplay = -1;
    @Deprecated
    protected boolean operaIdle = false;
    @Deprecated
    protected String operaLauncher;
    @Deprecated
    protected String operaLoggingFile;
    @Deprecated
    protected String operaLoggingLevel = "INFO";
    @Deprecated
    protected int operaPort = 0;
    @Deprecated
    protected String operaProfile;
    @Deprecated
    protected String operaProduct;
    @Deprecated
    protected boolean operaQuit = true;
    @Deprecated
    protected boolean operaRestart = true;
    protected Map<String, String> capabilityMap;
    protected String browserCapabilities;
    protected String originalBrowserCapabilities;
    protected boolean remoteReusable;
    protected boolean remote;

    public TypedWebDriverConfiguration(Class<T> type) {
        this.type = type;
        CapabilityMap capabilityMap = CapabilityMap.byWebDriverConfigurationType(type);
        if (capabilityMap != null) {
            this.browserCapabilities = this.originalBrowserCapabilities = capabilityMap.getReadableName();
        }
    }

    @Deprecated
    public TypedWebDriverConfiguration(Class<T> type, String implementationClass) {
        this.type = type;
        this.implementationClass = implementationClass;
    }

    public TypedWebDriverConfiguration<T> configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
        ConfigurationMapper.fromSystemConfiguration((DroneConfiguration)this, qualifier);
        if (this.originalBrowserCapabilities != null && !this.originalBrowserCapabilities.equals(this.browserCapabilities)) {
            log.log(Level.WARNING, "Arquillian configuration is specifying a Drone of type {0}, however test class specifically asked for {1}. As Drone cannot guarantee that those two are compatible, Arquillian configuration will be ignored.", new Object[]{this.browserCapabilities, this.originalBrowserCapabilities});
            this.browserCapabilities = this.originalBrowserCapabilities;
        }
        return this;
    }

    @Override
    @Deprecated
    public String getApplicationName() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.applicationName;
            }
        };
        return (String)interceptor.intercept("getApplicationName", new Class[0]);
    }

    @Override
    @Deprecated
    public String getApplicationVersion() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.applicationVersion;
            }
        };
        return (String)interceptor.intercept("getApplicationVersion", new Class[0]);
    }

    @Override
    public String getBrowserCapabilities() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                CapabilityMap capabilityMap = CapabilityMap.byWebDriverConfigurationType(TypedWebDriverConfiguration.this.type);
                if (capabilityMap != null && capabilityMap.getReadableName() != null) {
                    return capabilityMap.getReadableName();
                }
                return TypedWebDriverConfiguration.this.browserCapabilities;
            }
        };
        return (String)interceptor.intercept("getBrowserCapabilities", new Class[0]);
    }

    @Override
    @Deprecated
    public float getBrowserVersionNumeric() {
        CallInterceptor<Float> interceptor = new CallInterceptor<Float>(){

            @Override
            public Float invoke() {
                return Float.valueOf(TypedWebDriverConfiguration.this.browserVersionNumeric);
            }
        };
        return ((Float)interceptor.intercept("getBrowserVersionNumeric", new Class[0])).floatValue();
    }

    @Override
    public Capabilities getCapabilities() {
        CallInterceptor<Capabilities> interceptor = new CallInterceptor<Capabilities>(){

            @Override
            public Capabilities invoke() {
                CapabilityMap capabilityMap = CapabilityMap.byImplementationClass(TypedWebDriverConfiguration.this.getImplementationClass());
                DesiredCapabilities merged = new DesiredCapabilities();
                if (capabilityMap != null) {
                    merged = new DesiredCapabilities((Capabilities)capabilityMap.getCapabilities());
                }
                merged = new DesiredCapabilities(new Capabilities[]{merged, new DesiredCapabilities(TypedWebDriverConfiguration.this.capabilityMap)});
                return merged;
            }
        };
        return (Capabilities)interceptor.intercept("getCapabilities", new Class[0]);
    }

    @Override
    @Deprecated
    public String getChromeBinary() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.chromeBinary;
            }
        };
        return (String)interceptor.intercept("getChromeBinary", new Class[0]);
    }

    @Override
    public String getChromeDriverBinary() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.chromeDriverBinary;
            }
        };
        return (String)interceptor.intercept("getChromeDriverBinary", new Class[0]);
    }

    @Override
    @Deprecated
    public String getChromeSwitches() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.chromeSwitches;
            }
        };
        return (String)interceptor.intercept("getChromeSwitches", new Class[0]);
    }

    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }

    @Override
    @Deprecated
    public String getFirefoxBinary() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.firefoxBinary;
            }
        };
        return (String)interceptor.intercept("getFirefoxBinary", new Class[0]);
    }

    @Override
    @Deprecated
    public String getFirefoxProfile() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.firefoxProfile;
            }
        };
        return (String)interceptor.intercept("getFirefoxProfile", new Class[0]);
    }

    @Override
    public int getIePort() {
        CallInterceptor<Integer> interceptor = new CallInterceptor<Integer>(){

            @Override
            public Integer invoke() {
                return TypedWebDriverConfiguration.this.iePort;
            }
        };
        return (Integer)interceptor.intercept("getIePort", new Class[0]);
    }

    @Override
    public String getImplementationClass() {
        String browserCapabilities = this.getBrowserCapabilities();
        String implementationClassName = this.implementationClass;
        CapabilityMap capabilityMap = CapabilityMap.byImplementationClass(implementationClassName);
        if (capabilityMap == null) {
            capabilityMap = CapabilityMap.byDesiredCapabilities(browserCapabilities);
        }
        if (implementationClassName == null && capabilityMap != null) {
            implementationClassName = capabilityMap.getImplementationClass();
        }
        return implementationClassName;
    }

    @Override
    @Deprecated
    public String getOperaArguments() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.operaArguments;
            }
        };
        return (String)interceptor.intercept("getOperaArguments", new Class[0]);
    }

    @Override
    @Deprecated
    public String getOperaBinary() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.operaBinary;
            }
        };
        return (String)interceptor.intercept("getOperaBinary", new Class[0]);
    }

    @Override
    @Deprecated
    public int getOperaDisplay() {
        CallInterceptor<Integer> interceptor = new CallInterceptor<Integer>(){

            @Override
            public Integer invoke() {
                return TypedWebDriverConfiguration.this.operaDisplay;
            }
        };
        return (Integer)interceptor.intercept("getOperaDisplay", new Class[0]);
    }

    @Override
    @Deprecated
    public String getOperaLauncher() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.operaLauncher;
            }
        };
        return (String)interceptor.intercept("getOperaLauncher", new Class[0]);
    }

    @Override
    @Deprecated
    public String getOperaLoggingFile() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.operaLoggingFile;
            }
        };
        return (String)interceptor.intercept("getOperaLoggingFile", new Class[0]);
    }

    @Override
    @Deprecated
    public String getOperaLoggingLevel() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.operaLoggingLevel;
            }
        };
        return (String)interceptor.intercept("getOperaLoggingLevel", new Class[0]);
    }

    @Override
    @Deprecated
    public int getOperaPort() {
        CallInterceptor<Integer> interceptor = new CallInterceptor<Integer>(){

            @Override
            public Integer invoke() {
                return TypedWebDriverConfiguration.this.operaPort;
            }
        };
        return (Integer)interceptor.intercept("getOperaPort", new Class[0]);
    }

    @Override
    @Deprecated
    public String getOperaProduct() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.operaProduct;
            }
        };
        return (String)interceptor.intercept("getOperaProduct", new Class[0]);
    }

    @Override
    @Deprecated
    public String getOperaProfile() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.operaProfile;
            }
        };
        return (String)interceptor.intercept("getOperaProfile", new Class[0]);
    }

    @Override
    public URL getRemoteAddress() {
        CallInterceptor<URL> interceptor = new CallInterceptor<URL>(){

            @Override
            public URL invoke() {
                return TypedWebDriverConfiguration.this.remoteAddress;
            }
        };
        return (URL)interceptor.intercept("getRemoteAddress", new Class[0]);
    }

    @Override
    @Deprecated
    public String getUserAgent() {
        CallInterceptor<String> interceptor = new CallInterceptor<String>(){

            @Override
            public String invoke() {
                return TypedWebDriverConfiguration.this.userAgent;
            }
        };
        return (String)interceptor.intercept("getUserAgent", new Class[0]);
    }

    @Override
    @Deprecated
    public boolean isOperaAutostart() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.operaAutostart;
            }
        };
        return (Boolean)interceptor.intercept("isOperaAutostart", new Class[0]);
    }

    @Override
    @Deprecated
    public boolean isOperaIdle() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.operaIdle;
            }
        };
        return (Boolean)interceptor.intercept("isOperaIdle", new Class[0]);
    }

    @Override
    @Deprecated
    public boolean isOperaQuit() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.operaQuit;
            }
        };
        return (Boolean)interceptor.intercept("isOperaQuit", new Class[0]);
    }

    @Override
    @Deprecated
    public boolean isOperaRestart() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.operaRestart;
            }
        };
        return (Boolean)interceptor.intercept("isOperaRestart", new Class[0]);
    }

    @Override
    public boolean isRemote() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.remote;
            }
        };
        return (Boolean)interceptor.intercept("isRemote", new Class[0]);
    }

    @Override
    public boolean isRemoteReusable() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.remoteReusable;
            }
        };
        return (Boolean)interceptor.intercept("isRemoteReusable", new Class[0]);
    }

    @Override
    @Deprecated
    public boolean isUseJavaScript() {
        CallInterceptor<Boolean> interceptor = new CallInterceptor<Boolean>(){

            @Override
            public Boolean invoke() {
                return TypedWebDriverConfiguration.this.useJavaScript;
            }
        };
        return (Boolean)interceptor.intercept("isUseJavaScript", new Class[0]);
    }

    @Override
    @Deprecated
    public void setApplicationName(final String applicationName) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.applicationName = applicationName;
                return null;
            }
        };
        interceptor.intercept("setApplicationName", String.class);
    }

    @Override
    @Deprecated
    public void setApplicationVersion(final String applicationVersion) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.applicationVersion = applicationVersion;
                return null;
            }
        };
        interceptor.intercept("setApplicationVersion", String.class);
    }

    @Override
    public void setBrowserCapabilities(final String browserCapabilities) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.browserCapabilities = browserCapabilities;
                return null;
            }
        };
        interceptor.intercept("setBrowserCapabilities", String.class);
    }

    @Override
    @Deprecated
    public void setBrowserVersionNumeric(final float browserVersionNumeric) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.browserVersionNumeric = browserVersionNumeric;
                return null;
            }
        };
        interceptor.intercept("setBrowserVersionNumeric", Float.TYPE);
    }

    @Override
    @Deprecated
    public void setChromeBinary(final String chromeBinary) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.chromeBinary = chromeBinary;
                return null;
            }
        };
        interceptor.intercept("setChromeBinary", String.class);
    }

    @Override
    public void setChromeDriverBinary(final String chromeDriverBinary) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.chromeDriverBinary = chromeDriverBinary;
                return null;
            }
        };
        interceptor.intercept("setChromeDriverBinary", String.class);
    }

    @Override
    @Deprecated
    public void setChromeSwitches(final String chromeSwitches) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.chromeSwitches = chromeSwitches;
                return null;
            }
        };
        interceptor.intercept("setChromeSwitches", String.class);
    }

    @Override
    @Deprecated
    public void setFirefoxBinary(final String firefoxBinary) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.firefoxBinary = firefoxBinary;
                return null;
            }
        };
        interceptor.intercept("setFirefoxBinary", String.class);
    }

    @Override
    @Deprecated
    public void setFirefoxProfile(final String firefoxProfile) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.firefoxProfile = firefoxProfile;
                return null;
            }
        };
        interceptor.intercept("setFirefoxProfile", String.class);
    }

    @Override
    public void setIePort(final int iePort) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.iePort = iePort;
                return null;
            }
        };
        interceptor.intercept("setIePort", Integer.TYPE);
    }

    @Override
    @Deprecated
    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    @Override
    @Deprecated
    public void setOperaArguments(final String operaArguments) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaArguments = operaArguments;
                return null;
            }
        };
        interceptor.intercept("setOperaArguments", String.class);
    }

    @Override
    @Deprecated
    public void setOperaAutostart(final boolean operaAutostart) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaAutostart = operaAutostart;
                return null;
            }
        };
        interceptor.intercept("setOperaAutostart", Integer.TYPE);
    }

    @Override
    @Deprecated
    public void setOperaBinary(final String operaBinary) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaBinary = operaBinary;
                return null;
            }
        };
        interceptor.intercept("setOperaBinary", String.class);
    }

    @Override
    @Deprecated
    public void setOperaDisplay(final int operaDisplay) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaDisplay = operaDisplay;
                return null;
            }
        };
        interceptor.intercept("setOperaDisplay", Integer.TYPE);
    }

    @Override
    @Deprecated
    public void setOperaIdle(final boolean operaIdle) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaIdle = operaIdle;
                return null;
            }
        };
        interceptor.intercept("setOperaIdle", Boolean.TYPE);
    }

    @Override
    @Deprecated
    public void setOperaLauncher(final String operaLauncher) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaLauncher = operaLauncher;
                return null;
            }
        };
        interceptor.intercept("setOperaLauncher", String.class);
    }

    @Override
    @Deprecated
    public void setOperaLoggingFile(final String operaLoggingFile) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaLoggingFile = operaLoggingFile;
                return null;
            }
        };
        interceptor.intercept("setOperaLoggingFile", String.class);
    }

    @Override
    @Deprecated
    public void setOperaLoggingLevel(final String operaLoggingLevel) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaLoggingLevel = operaLoggingLevel;
                return null;
            }
        };
        interceptor.intercept("setOperaLoggingLevel", String.class);
    }

    @Override
    @Deprecated
    public void setOperaPort(final int operaPort) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaPort = operaPort;
                return null;
            }
        };
        interceptor.intercept("setOperaPort", Integer.TYPE);
    }

    @Override
    @Deprecated
    public void setOperaProduct(final String operaProduct) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaProduct = operaProduct;
                return null;
            }
        };
        interceptor.intercept("setOperaProduct", String.class);
    }

    @Override
    @Deprecated
    public void setOperaProfile(final String operaProfile) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaProfile = operaProfile;
                return null;
            }
        };
        interceptor.intercept("setOperaProfile", String.class);
    }

    @Override
    @Deprecated
    public void setOperaQuit(final boolean operaQuit) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaQuit = operaQuit;
                return null;
            }
        };
        interceptor.intercept("setOperaQuit", Boolean.TYPE);
    }

    @Override
    @Deprecated
    public void setOperaRestart(final boolean operaRestart) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.operaRestart = operaRestart;
                return null;
            }
        };
        interceptor.intercept("setOperaRestart", Boolean.TYPE);
    }

    @Override
    public void setRemote(final boolean remote) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.remote = remote;
                return null;
            }
        };
        interceptor.intercept("setRemote", Boolean.TYPE);
    }

    @Override
    public void setRemoteAddress(final URL remoteAddress) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.remoteAddress = remoteAddress;
                return null;
            }
        };
        interceptor.intercept("setRemoteAddress", URL.class);
    }

    @Override
    public void setRemoteReusable(final boolean remoteReusable) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.remoteReusable = remoteReusable;
                return null;
            }
        };
        interceptor.intercept("setRemoteReusable", Boolean.TYPE);
    }

    @Override
    @Deprecated
    public void setUseJavaScript(final boolean useJavaScript) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.useJavaScript = useJavaScript;
                return null;
            }
        };
        interceptor.intercept("setUseJavaScript", Boolean.TYPE);
    }

    @Override
    @Deprecated
    public void setUserAgent(final String userAgent) {
        CallInterceptor<Void> interceptor = new CallInterceptor<Void>(){

            @Override
            public Void invoke() {
                TypedWebDriverConfiguration.this.userAgent = userAgent;
                return null;
            }
        };
        interceptor.intercept("setUserAgent", String.class);
    }

    static {
        try {
            DEFAULT_REMOTE_URL = new URL("http://localhost:14444/wd/hub");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        DEFAULT_BROWSER_CAPABILITIES = CapabilityMap.HTMLUNIT.getReadableName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CallInterceptor<R> {
        private Boolean exists = null;

        private CallInterceptor() {
        }

        private String decamelize(String name) {
            int prefixLength = name.startsWith("is") ? 2 : 3;
            StringBuilder sb = new StringBuilder(name.substring(prefixLength));
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            return sb.toString();
        }

        public R intercept(String name, Class<?> ... parameterTypes) {
            if (this.methodExists(name, parameterTypes)) {
                return this.invoke();
            }
            String propertyName = this.decamelize(name);
            String configurationName = TypedWebDriverConfiguration.this.type.getSimpleName().replaceAll("ConfigurationType", "");
            throw new IllegalStateException("Property with name " + propertyName + " is not valid for " + configurationName + ". Make sure you are using proper configuration element for the WebDriver browser type");
        }

        public abstract R invoke();

        private boolean methodExists(String name, Class<?>[] parameterTypes) {
            if (this.exists != null) {
                return this.exists;
            }
            try {
                TypedWebDriverConfiguration.this.type.getMethod(name, parameterTypes);
                this.exists = true;
            }
            catch (NoSuchMethodException e) {
                this.exists = false;
            }
            return this.exists;
        }
    }
}

