/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.ChromeDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromeDriverFactory
implements Configurator<ChromeDriver, TypedWebDriverConfiguration<ChromeDriverConfiguration>>,
Instantiator<ChromeDriver, TypedWebDriverConfiguration<ChromeDriverConfiguration>>,
Destructor<ChromeDriver> {
    private static final String CHROME_DRIVER_BINARY_KEY = "webdriver.chrome.driver";

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(ChromeDriver instance) {
        instance.quit();
    }

    public ChromeDriver createInstance(TypedWebDriverConfiguration<ChromeDriverConfiguration> configuration) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String driverBinary = configuration.getChromeDriverBinary();
        String binary = (String)capabilities.getCapability("chrome.binary");
        String chromeSwitches = (String)capabilities.getCapability("chrome.switches");
        if (Validate.empty(driverBinary)) {
            driverBinary = SecurityActions.getProperty(CHROME_DRIVER_BINARY_KEY);
        }
        if (Validate.nonEmpty(driverBinary)) {
            Validate.isExecutable(driverBinary, "Chrome driver binary must point to an executable file, " + driverBinary);
            SecurityActions.setProperty(CHROME_DRIVER_BINARY_KEY, driverBinary);
        }
        if (Validate.nonEmpty(binary)) {
            Validate.isExecutable(binary, "Chrome binary must point to an executable file, " + binary);
        }
        if (Validate.nonEmpty(chromeSwitches)) {
            capabilities.setCapability("chrome.switches", this.getChromeSwitches(chromeSwitches));
        }
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, ChromeDriver.class);
    }

    public TypedWebDriverConfiguration<ChromeDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return new TypedWebDriverConfiguration<ChromeDriverConfiguration>(ChromeDriverConfiguration.class).configure(descriptor, qualifier);
    }

    private List<String> getChromeSwitches(String valueString) {
        ArrayList<String> properties = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(valueString, " ");
        while (tokenizer.hasMoreTokens()) {
            String property = tokenizer.nextToken().trim();
            if (property.indexOf("--") == -1) continue;
            properties.add(property);
        }
        return properties;
    }
}

