/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.FirefoxDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.factory.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxDriverFactory
implements Configurator<FirefoxDriver, TypedWebDriverConfiguration<FirefoxDriverConfiguration>>,
Instantiator<FirefoxDriver, TypedWebDriverConfiguration<FirefoxDriverConfiguration>>,
Destructor<FirefoxDriver> {
    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(FirefoxDriver instance) {
        instance.quit();
    }

    public FirefoxDriver createInstance(TypedWebDriverConfiguration<FirefoxDriverConfiguration> configuration) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String binary = (String)configuration.getCapabilities().getCapability("firefox_binary");
        String profile = (String)configuration.getCapabilities().getCapability("firefox_profile");
        if (Validate.nonEmpty(binary)) {
            Validate.isExecutable(binary, "Firefox binary does not point to a valid executable,  " + binary);
        }
        if (Validate.nonEmpty(profile)) {
            Validate.isValidPath(profile, "Firefox profile does not point to a valid path " + profile);
        }
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, FirefoxDriver.class);
    }

    public TypedWebDriverConfiguration<FirefoxDriverConfiguration> createConfiguration(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        return new TypedWebDriverConfiguration<FirefoxDriverConfiguration>(FirefoxDriverConfiguration.class).configure(descriptor, qualifier);
    }
}

