/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.lang.reflect.Field;
import java.net.URL;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.UnableReuseSessionException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReusableRemoteWebDriver
extends RemoteWebDriver {
    ReusableRemoteWebDriver() {
    }

    public static ReusableRemoteWebDriver fromRemoteWebDriver(RemoteWebDriver remoteWebDriver) {
        return new ReusableRemoteWebDriver(remoteWebDriver);
    }

    public static ReusableRemoteWebDriver fromReusedSession(URL remoteAddress, Capabilities desiredCapabilities, SessionId sessionId) throws UnableReuseSessionException {
        return new ReusableRemoteWebDriver(remoteAddress, desiredCapabilities, sessionId);
    }

    private ReusableRemoteWebDriver(RemoteWebDriver remoteWebDriver) {
        this.setCommandExecutor(remoteWebDriver.getCommandExecutor());
        this.reuseSession(remoteWebDriver.getSessionId(), remoteWebDriver.getCapabilities());
        try {
            this.checkReusability();
        }
        catch (UnableReuseSessionException e) {
            throw new IllegalStateException("Reusing RemoteWebDriver session unexpectedly failed", e);
        }
    }

    private ReusableRemoteWebDriver(URL remoteAddress, Capabilities desiredCapabilities, SessionId sessionId) throws UnableReuseSessionException {
        this.setCommandExecutor((CommandExecutor)new HttpCommandExecutor(remoteAddress));
        this.startClient();
        this.reuseSession(sessionId, desiredCapabilities);
        this.checkReusability();
    }

    private void checkReusability() throws UnableReuseSessionException {
        try {
            this.getCurrentUrl();
        }
        catch (WebDriverException e) {
            throw new UnableReuseSessionException(e);
        }
    }

    protected final void reuseSession(SessionId sessionId, Capabilities desiredCapabilities) {
        this.setReusedSessionId(sessionId);
        this.setReusedCapabilities(desiredCapabilities);
    }

    void setReusedSessionId(SessionId sessionId) {
        Field sessionIdField = ReusableRemoteWebDriver.getFieldSafely((Object)this, RemoteWebDriver.class, "sessionId");
        ReusableRemoteWebDriver.writeValueToField((Object)this, sessionIdField, sessionId);
    }

    void setReusedCapabilities(Capabilities capabilities) {
        Field capabilitiesField = ReusableRemoteWebDriver.getFieldSafely((Object)this, RemoteWebDriver.class, "capabilities");
        ReusableRemoteWebDriver.writeValueToField((Object)this, capabilitiesField, capabilities);
    }

    private static Field getFieldSafely(Object object, Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void writeValueToField(Object object, Field field, Object value) {
        boolean wasAccessible = field.isAccessible();
        if (!wasAccessible) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (!wasAccessible) {
            field.setAccessible(false);
        }
    }
}

