/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxPrefsReader {
    private static final Pattern PREFERENCE_PATTERN = Pattern.compile("user_pref\\(\"([^\"]+)\", (\"?.+?\"?)\\);");

    public static Map<String, Object> getPreferences(File prefs) throws IllegalArgumentException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(prefs));
            String line = null;
            while ((line = reader.readLine()) != null) {
                Matcher m = PREFERENCE_PATTERN.matcher(line);
                if (!m.matches()) continue;
                map.put(m.group(1), FirefoxPrefsReader.preferenceAsValue(m.group(2)));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("User preferences for firefox " + prefs.getAbsolutePath() + " does not represent a valid preferences file", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        return map;
    }

    private static Object preferenceAsValue(String toConvert) throws IOException {
        if (toConvert.startsWith("\"") && toConvert.endsWith("\"")) {
            return toConvert.substring(1, toConvert.length() - 1).replaceAll("\\\\\\\\", "\\\\");
        }
        if ("false".equals(toConvert) || "true".equals(toConvert)) {
            return Boolean.parseBoolean(toConvert);
        }
        try {
            return Integer.parseInt(toConvert);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid property format for user preferences " + toConvert);
        }
    }
}

