/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.binary.handler.PhantomJSDriverBinaryHandler;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSDriverFactory
extends AbstractWebDriverFactory<PhantomJSDriver>
implements Configurator<PhantomJSDriver, WebDriverConfiguration>,
Instantiator<PhantomJSDriver, WebDriverConfiguration>,
Destructor<PhantomJSDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.PhantomJS().getReadableName();
    private static final String PHANTOMJS_DEFAULT_EXECUTABLE = "phantomjs";

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(PhantomJSDriver instance) {
        instance.quit();
    }

    public PhantomJSDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = this.getCapabilities(configuration, true);
        PhantomJSDriverService phantomJSDriverService = PhantomJSDriverService.createDefaultService((Capabilities)capabilities);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{PhantomJSDriverService.class, Capabilities.class}, new Object[]{phantomJSDriverService, capabilities}, PhantomJSDriver.class);
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        this.reformatCLIArgumentsInCapToArray(capabilities);
        if (!this.isDefaultExecutablePresent()) {
            new PhantomJSDriverBinaryHandler(capabilities).checkAndSetBinary(performValidations);
        }
        return capabilities;
    }

    public void reformatCLIArgumentsInCapToArray(DesiredCapabilities capabilities) {
        this.reformatCapabilityToArray(capabilities, "phantomjs.cli.args");
        this.reformatCapabilityToArray(capabilities, "phantomjs.ghostdriver.cli.args");
    }

    private void reformatCapabilityToArray(DesiredCapabilities capabilities, String capabilityName) {
        Object capability = capabilities.getCapability(capabilityName);
        if (capability != null && capability instanceof String) {
            String[] splitArgs = ((String)capability).split(" ");
            capabilities.setCapability(capabilityName, (Object)splitArgs);
        }
    }

    private boolean isDefaultExecutablePresent() {
        return Validate.isCommandExecutable(PHANTOMJS_DEFAULT_EXECUTABLE);
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

