/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SerializationWhitelist {
    private static final Logger log = Logger.getLogger(SerializationWhitelist.class.getName());
    private final Set<String> whitelist = new HashSet<String>();

    public SerializationWhitelist() {
        this.whitelist.add(Boolean.class.getName());
        this.whitelist.add(Byte.class.getName());
        this.whitelist.add(Character.class.getName());
        this.whitelist.add(Character.Subset.class.getName());
        this.whitelist.add(Character.UnicodeBlock.class.getName());
        this.whitelist.add(Class.class.getName());
        this.whitelist.add(ClassLoader.class.getName());
        this.whitelist.add(Compiler.class.getName());
        this.whitelist.add(Double.class.getName());
        this.whitelist.add(Enum.class.getName());
        this.whitelist.add(Float.class.getName());
        this.whitelist.add(InheritableThreadLocal.class.getName());
        this.whitelist.add(Integer.class.getName());
        this.whitelist.add(Long.class.getName());
        this.whitelist.add(Math.class.getName());
        this.whitelist.add(Number.class.getName());
        this.whitelist.add(Object.class.getName());
        this.whitelist.add(Package.class.getName());
        this.whitelist.add(Process.class.getName());
        this.whitelist.add(ProcessBuilder.class.getName());
        this.whitelist.add(Runtime.class.getName());
        this.whitelist.add(RuntimePermission.class.getName());
        this.whitelist.add(SecurityManager.class.getName());
        this.whitelist.add(Short.class.getName());
        this.whitelist.add(StackTraceElement.class.getName());
        this.whitelist.add(StrictMath.class.getName());
        this.whitelist.add(String.class.getName());
        this.whitelist.add(StringBuffer.class.getName());
        this.whitelist.add(StringBuilder.class.getName());
        this.whitelist.add(System.class.getName());
        this.whitelist.add(Thread.class.getName());
        this.whitelist.add(ThreadGroup.class.getName());
        this.whitelist.add(ThreadLocal.class.getName());
        this.whitelist.add(Throwable.class.getName());
        this.whitelist.add(Void.class.getName());
        this.whitelist.add("B");
        this.whitelist.add("C");
        this.whitelist.add("D");
        this.whitelist.add("F");
        this.whitelist.add("I");
        this.whitelist.add("J");
        this.whitelist.add("S");
        this.whitelist.add("Z");
        this.whitelist.add("[B");
        this.whitelist.add("[C");
        this.whitelist.add("[D");
        this.whitelist.add("[F");
        this.whitelist.add("[I");
        this.whitelist.add("[J");
        this.whitelist.add("[S");
        this.whitelist.add("[Z");
    }

    public SerializationWhitelist enableClass(String fqcn) {
        this.whitelist.add(fqcn);
        return this;
    }

    public boolean isEnabled(String fqcn) {
        try {
            Class<?> clazz = Class.forName(fqcn);
            if (!Serializable.class.isAssignableFrom(clazz)) {
                log.log(Level.FINER, "Ignoring class {0} from Serialization, it is not Serializable", fqcn);
                return false;
            }
            if (!this.whitelist.contains(fqcn)) {
                log.log(Level.FINER, "Ignoring class {0} from Serialization, it was not whitelisted", fqcn);
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            log.log(Level.WARNING, "Ignoring class {0} from Serialization, it was not found on classpath", fqcn);
            return false;
        }
        return true;
    }
}

