/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.client;

import java.lang.reflect.Method;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.extension.byteman.impl.common.ExtractScriptUtil;
import org.jboss.arquillian.extension.byteman.impl.common.SubmitUtil;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.ClassLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleInstaller {
    public static final String CLASS_KEY_PREFIX = "Class:";
    public static final String METHOD_KEY_PREFIX = "Method:";
    @Inject
    private Instance<Deployment> deploymentInstance;
    @Inject
    private Instance<Container> containerInstance;
    @Inject
    private Instance<ArquillianDescriptor> descriptorInst;

    public void installClass(@Observes BeforeClass event) {
        BytemanConfiguration config = BytemanConfiguration.from((ArquillianDescriptor)this.descriptorInst.get());
        String script = ExtractScriptUtil.extract((ClassLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.install(this.generateKey(CLASS_KEY_PREFIX), script, config.clientAgentPort());
        }
    }

    public void uninstallClass(@Observes AfterClass event) {
        BytemanConfiguration config = BytemanConfiguration.from((ArquillianDescriptor)this.descriptorInst.get());
        String script = ExtractScriptUtil.extract((ClassLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.uninstall(this.generateKey(CLASS_KEY_PREFIX), script, config.clientAgentPort());
        }
    }

    public void installMethod(@Observes Before event) {
        if (!RuleInstaller.shouldRun((Deployment)this.deploymentInstance.get(), (Container)this.containerInstance.get(), (TestEvent)event)) {
            return;
        }
        BytemanConfiguration config = BytemanConfiguration.from((ArquillianDescriptor)this.descriptorInst.get());
        String script = ExtractScriptUtil.extract((TestLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.install(this.generateKey(METHOD_KEY_PREFIX), script, config.clientAgentPort());
        }
    }

    public void uninstallMethod(@Observes After event) {
        if (!RuleInstaller.shouldRun((Deployment)this.deploymentInstance.get(), (Container)this.containerInstance.get(), (TestEvent)event)) {
            return;
        }
        BytemanConfiguration config = BytemanConfiguration.from((ArquillianDescriptor)this.descriptorInst.get());
        String script = ExtractScriptUtil.extract((TestLifecycleEvent)event);
        if (script != null) {
            SubmitUtil.uninstall(this.generateKey(METHOD_KEY_PREFIX), script, config.clientAgentPort());
        }
    }

    private String generateKey(String prefix) {
        return prefix + Thread.currentThread().getName();
    }

    private static boolean shouldRun(Deployment deployment, Container container, TestEvent event) {
        if (RuleInstaller.isRunAsClient(deployment, event.getTestClass().getJavaClass(), event.getTestMethod())) {
            return true;
        }
        return RuleInstaller.isLocalContainer(container);
    }

    private static boolean isRunAsClient(Deployment deployment, Class<?> testClass, Method testMethod) {
        boolean runAsClient = true;
        if (deployment != null) {
            runAsClient = !deployment.getDescription().testable();
            boolean bl = runAsClient = deployment.isDeployed() ? runAsClient : true;
            if (testMethod.isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            } else if (testClass.isAnnotationPresent(RunAsClient.class)) {
                runAsClient = true;
            }
        }
        return runAsClient;
    }

    private static boolean isLocalContainer(Container container) {
        if (container == null || container.getDeployableContainer() == null || container.getDeployableContainer().getDefaultProtocol() == null) {
            return false;
        }
        return "Local".equals(container.getDeployableContainer().getDefaultProtocol().getName());
    }
}

