/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IOUtil {
    private static final Logger log = Logger.getLogger(IOUtil.class.getName());
    private static final String CHARSET_UTF8 = "UTF-8";

    private IOUtil() {
        throw new UnsupportedOperationException("No instances should be created; stateless class");
    }

    public static String asUTF8String(InputStream in) {
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, CHARSET_UTF8));
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append('\n');
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtaining string from " + in, ioe);
        }
        finally {
            block11: {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    if (!log.isLoggable(Level.FINER)) break block11;
                    log.finer("Could not close stream due to: " + ignore.getMessage() + "; ignoring");
                }
            }
        }
        return buffer.toString();
    }
}

