/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.byteman.impl.container;

import java.util.EnumSet;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.event.Event;
import org.jboss.arquillian.extension.byteman.api.ExecType;
import org.jboss.arquillian.extension.byteman.impl.common.AbstractRuleInstaller;
import org.jboss.arquillian.extension.byteman.impl.common.BytemanConfiguration;
import org.jboss.arquillian.extension.byteman.impl.common.ExecContext;
import org.jboss.arquillian.extension.byteman.impl.common.ExtractScriptUtil;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.ClassLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;

public class RuleInstaller
extends AbstractRuleInstaller {
    private static BytemanConfiguration getConfiguration() {
        return BytemanConfiguration.from(Thread.currentThread().getContextClassLoader().getResourceAsStream(BytemanConfiguration.BYTEMAN_CONFIG));
    }

    public void installClassClient(@Observes BeforeClass event) {
        ExecContext context = this.getExecContextContainer((Event)event);
        if (!RuleInstaller.isInstalled("Class:", context)) {
            String script = ExtractScriptUtil.extract(context, (ClassLifecycleEvent)event);
            RuleInstaller.install("Class:", script, context);
        }
    }

    public void installMethodClient(@Observes Before event) {
        ExecContext context = this.getExecContextContainer((Event)event);
        String script = ExtractScriptUtil.extract(context, (TestLifecycleEvent)event);
        RuleInstaller.install("Method:", script, context);
    }

    public void uninstallMethodClient(@Observes After event) {
        ExecContext context = this.getExecContextContainer((Event)event);
        String script = ExtractScriptUtil.extract(context, (TestLifecycleEvent)event);
        RuleInstaller.uninstall("Method:", script, context);
    }

    protected ExecContext getExecContextContainer(Event event) {
        BytemanConfiguration configuration = RuleInstaller.getConfiguration();
        return new ExecContext(configuration.containerAgentPort(), EnumSet.of(ExecType.ALL, ExecType.CONTAINER), configuration);
    }

    protected boolean shouldRun(TestEvent event) {
        return true;
    }
}

