/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.phantom.resolver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.jboss.arquillian.phantom.resolver.PhantomJSBinary;
import org.jboss.arquillian.phantom.resolver.PhantomJSBinaryResolver;
import org.jboss.arquillian.phantom.resolver.ResolverConfiguration;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.service.DriverService;

public class ResolvingPhantomJSDriverService
extends DriverService {
    private static final String PHANTOMJS_DEFAULT_EXECUTABLE = "phantomjs";
    private static final Logger LOG = Logger.getLogger(ResolvingPhantomJSDriverService.class.getName());

    private ResolvingPhantomJSDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static DriverService createDefaultService() throws IOException {
        return ResolvingPhantomJSDriverService.createDefaultService(null);
    }

    public static DriverService createDefaultService(Capabilities capabilities) throws IOException {
        ResolverConfiguration configuration = ResolverConfiguration.get(capabilities);
        if (!configuration.preferResolved() && ResolvingPhantomJSDriverService.isDefaultExecutablePresent()) {
            return PhantomJSDriverService.createDefaultService((Capabilities)capabilities);
        }
        PhantomJSBinary binary = ResolvingPhantomJSDriverService.resolveBinary(configuration);
        DesiredCapabilities newCapabilities = new DesiredCapabilities(capabilities);
        newCapabilities.setCapability("phantomjs.binary.path", binary.getLocation().getAbsolutePath());
        return PhantomJSDriverService.createDefaultService((Capabilities)newCapabilities);
    }

    private static boolean isDefaultExecutablePresent() {
        return CommandLine.find((String)PHANTOMJS_DEFAULT_EXECUTABLE) != null;
    }

    private static PhantomJSBinary resolveBinary(ResolverConfiguration configuration) throws IOException {
        PhantomJSBinaryResolver binaryResolver = configuration.resolver();
        File executablePath = configuration.executablePath();
        PhantomJSBinary binary = binaryResolver.resolve(executablePath);
        return binary;
    }
}

