/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.client.execution;

import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.jboss.arquillian.warp.ClientAction;
import org.jboss.arquillian.warp.RequestExecution;
import org.jboss.arquillian.warp.RequestFilter;
import org.jboss.arquillian.warp.ServerAssertion;
import org.jboss.arquillian.warp.client.execution.AssertionHolder;
import org.jboss.arquillian.warp.client.execution.RequestEnrichment;
import org.jboss.arquillian.warp.client.execution.ResponseEnrichment;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.exception.ServerWarpExecutionException;
import org.jboss.arquillian.warp.shared.RequestPayload;
import org.jboss.arquillian.warp.shared.ResponsePayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestExecutionImpl
implements RequestExecution {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private ClientAction action;
    private RequestFilter<?> filter;
    private ServerAssertion assertion;
    private FutureTask<ResponsePayload> payloadFuture;

    public RequestExecutionImpl(ClientAction action) {
        this.action = action;
    }

    public RequestExecutionImpl(RequestFilter<?> filter) {
        this.filter = filter;
    }

    public <T extends ServerAssertion> T verify(T assertion) {
        this.assertion = assertion;
        this.execute();
        return (T)this.assertion;
    }

    public RequestExecution filter(RequestFilter<?> filter) {
        this.filter = filter;
        return this;
    }

    public RequestExecution execute(ClientAction action) {
        this.action = action;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        try {
            this.setupServerAssertion();
            this.executeClientAction();
            this.awaitServerExecution();
        }
        finally {
            this.cleanup();
        }
    }

    private void setupServerAssertion() {
        AssertionHolder.advertise();
        AssertionHolder.setExpectedRequests(1);
        RequestPayload payload = new RequestPayload(this.assertion);
        RequestEnrichment request = new RequestEnrichment(payload, this.filter);
        AssertionHolder.addRequest(request);
        AssertionHolder.finished();
        this.payloadFuture = new FutureTask<ResponsePayload>(new PushAssertion());
        this.executor.submit(this.payloadFuture);
    }

    private void executeClientAction() {
        try {
            this.action.action();
        }
        catch (Exception e) {
            throw new ClientActionException(e);
        }
    }

    private void awaitServerExecution() {
        ResponsePayload responsePayload;
        try {
            responsePayload = this.payloadFuture.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Throwable throwable = responsePayload.getThrowable();
        if (throwable != null) {
            this.propagateFailure(throwable);
        }
        this.assertion = responsePayload.getAssertion();
    }

    private void cleanup() {
        AssertionHolder.finishEnrichmentRound();
    }

    private void propagateFailure(Throwable throwable) {
        if (throwable instanceof AssertionError) {
            throw (AssertionError)((Object)throwable);
        }
        if (throwable instanceof ClientWarpExecutionException) {
            throw (ClientWarpExecutionException)throwable;
        }
        throw new ServerWarpExecutionException(throwable);
    }

    public static class ClientActionException
    extends RuntimeException {
        private static final long serialVersionUID = 7267806785171391801L;

        public ClientActionException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PushAssertion
    implements Callable<ResponsePayload> {
        @Override
        public ResponsePayload call() throws Exception {
            Set<ResponseEnrichment> responses = AssertionHolder.getResponses();
            ResponseEnrichment response = responses.iterator().next();
            return response.getPayload();
        }
    }
}

