/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.client.proxy;

import java.lang.annotation.Annotation;
import java.net.URL;
import org.jboss.arquillian.container.test.impl.enricher.resource.URLResourceProvider;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.warp.client.proxy.ProxyHolder;
import org.jboss.arquillian.warp.client.proxy.URLMapping;
import org.jboss.arquillian.warp.utils.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyURLProvider
implements ResourceProvider {
    @Inject
    Instance<ServiceLoader> serviceLoader;
    @Inject
    Instance<URLMapping> mapping;
    @Inject
    Instance<ProxyHolder> proxyHolder;
    @Inject
    Instance<Injector> injector;
    URLResourceProvider urlResourceProvider = new URLResourceProvider();

    public boolean canProvide(Class<?> type) {
        return URL.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        ((Injector)this.injector.get()).inject((Object)this.urlResourceProvider);
        URL realUrl = (URL)this.urlResourceProvider.lookup(resource, qualifiers);
        if ("http".equals(realUrl.getProtocol())) {
            return this.getProxyUrl(realUrl);
        }
        return realUrl;
    }

    private URL getProxyUrl(URL realUrl) {
        URL baseRealUrl = URLUtils.getUrlBase(realUrl);
        URL baseProxyUrl = ((URLMapping)this.mapping.get()).getProxyURL(baseRealUrl);
        URL proxyUrl = URLUtils.buildUrl(baseProxyUrl, realUrl.getPath());
        ((ProxyHolder)this.proxyHolder.get()).startProxyForUrl(baseProxyUrl, baseRealUrl);
        return proxyUrl;
    }
}

