/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.warp.server.filter.DoFilterCommand;
import org.jboss.arquillian.warp.server.filter.WarpRequest;
import org.jboss.arquillian.warp.server.filter.WarpRequestProcessor;

@WebFilter(urlPatterns={"/*"}, asyncSupported=true)
public class WarpFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && resp instanceof HttpServletResponse) {
            this.doFilterHttp((HttpServletRequest)req, (HttpServletResponse)resp, chain);
        } else {
            chain.doFilter(req, resp);
        }
    }

    private void doFilterHttp(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        WarpRequest warpRequest = new WarpRequest(req);
        if (warpRequest.isEnriched()) {
            this.doFilterWarp(req, resp, chain, warpRequest);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void doFilterWarp(HttpServletRequest req, HttpServletResponse resp, FilterChain chain, WarpRequest warpRequest) throws IOException, ServletException {
        DoFilterCommand filterCommand = this.createFilterCommand(chain);
        WarpRequestProcessor requestProcessor = new WarpRequestProcessor(req, resp);
        requestProcessor.process(warpRequest, filterCommand);
    }

    private DoFilterCommand createFilterCommand(final FilterChain chain) {
        return new DoFilterCommand(){

            public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
                chain.doFilter(request, response);
            }
        };
    }

    public void destroy() {
    }
}

