/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.server.filter;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ManagerBuilder;
import org.jboss.arquillian.warp.ServerAssertion;
import org.jboss.arquillian.warp.server.enrich.HttpServletRequestEnricher;
import org.jboss.arquillian.warp.server.enrich.HttpServletResponseEnricher;
import org.jboss.arquillian.warp.server.filter.DoFilterCommand;
import org.jboss.arquillian.warp.server.filter.NonWritingPrintWriter;
import org.jboss.arquillian.warp.server.filter.NonWritingServletOutputStream;
import org.jboss.arquillian.warp.server.filter.WarpLifecycle;
import org.jboss.arquillian.warp.server.filter.WarpRequest;
import org.jboss.arquillian.warp.shared.ResponsePayload;
import org.jboss.arquillian.warp.utils.SerializationUtils;

public class WarpRequestProcessor {
    private static final String DEFAULT_EXTENSION_CLASS = "org.jboss.arquillian.core.impl.loadable.LoadableExtensionLoader";
    private HttpServletRequest request;
    private HttpServletResponse response;
    private NonWritingServletOutputStream stream;
    private NonWritingPrintWriter writer;
    private HttpServletResponseWrapper nonWritingResponse;

    public WarpRequestProcessor(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.nonWritingResponse = new NonWritingResponseWrapper(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WarpRequest warpRequest, DoFilterCommand filterCommand) throws IOException {
        ResponsePayload responsePayload;
        boolean requestFailed = false;
        try {
            ManagerBuilder builder = ManagerBuilder.from().extension(Class.forName(DEFAULT_EXTENSION_CLASS));
            Manager manager = builder.create();
            manager.start();
            manager.bind(ApplicationScoped.class, Manager.class, (Object)manager);
            WarpLifecycle warpLifecycle = new WarpLifecycle();
            manager.inject((Object)warpLifecycle);
            ServerAssertion serverAssertion = warpRequest.getServerAssertion();
            filterCommand.setRequest((ServletRequest)this.request);
            filterCommand.setResponse((ServletResponse)this.nonWritingResponse);
            HttpServletRequestEnricher.setRequest(this.request);
            HttpServletResponseEnricher.setResponse(this.response);
            responsePayload = warpLifecycle.execute(manager, (ServletRequest)this.request, filterCommand, serverAssertion);
        }
        catch (Throwable e) {
            responsePayload = new ResponsePayload(e);
            requestFailed = true;
        }
        finally {
            HttpServletRequestEnricher.setRequest(null);
            HttpServletResponseEnricher.setResponse(null);
        }
        if (responsePayload.getThrowable() != null) {
            responsePayload.getThrowable().printStackTrace();
        }
        this.enrichResponse(this.response, responsePayload);
        if (this.writer != null) {
            this.writer.finallyWriteAndClose(this.response.getOutputStream());
        }
        if (this.stream != null) {
            this.stream.finallyWriteAndClose(this.response.getOutputStream());
        }
        if (requestFailed && !this.response.isCommitted()) {
            this.response.sendError(500);
        }
    }

    private void enrichResponse(HttpServletResponse httpResp, ResponsePayload payload) {
        String enrichment = SerializationUtils.serializeToBase64(payload);
        httpResp.setHeader("X-Arq-Enrichment-Response", enrichment);
    }

    private class NonWritingResponseWrapper
    extends HttpServletResponseWrapper {
        public NonWritingResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (WarpRequestProcessor.this.stream == null) {
                WarpRequestProcessor.this.stream = new NonWritingServletOutputStream();
            }
            return WarpRequestProcessor.this.stream;
        }

        public PrintWriter getWriter() throws IOException {
            if (WarpRequestProcessor.this.writer == null) {
                WarpRequestProcessor.this.writer = NonWritingPrintWriter.newInstance();
            }
            return WarpRequestProcessor.this.writer;
        }
    }
}

