/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.utils;

import java.net.MalformedURLException;
import java.net.URL;

public final class URLUtils {
    private URLUtils() {
    }

    public static URL buildUrl(String context, String ... relocations) {
        try {
            return URLUtils.buildUrl(new URL(context), relocations);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("URL('" + context + "') isn't valid URL"));
        }
    }

    public static URL buildUrl(URL context, String ... relocations) {
        URL url = context;
        for (String move : relocations) {
            try {
                url = new URL(url, move);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)("URL('" + url + "', '" + move + "') isn't valid URL"));
            }
        }
        return url;
    }

    public static URL getUrlBase(URL url) {
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), "");
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("URL('" + url + "') was unable to transform to base URL"));
        }
    }

    public static URL changeBase(URL url, URL base) {
        base = URLUtils.getUrlBase(base);
        return URLUtils.buildUrl(base, url.getFile());
    }
}

