/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.GrapheneEnricher;
import org.jboss.arquillian.graphene.enricher.PageFragmentEnricher;
import org.jboss.arquillian.graphene.enricher.PageObjectEnricher;
import org.jboss.arquillian.graphene.enricher.WebElementEnricher;
import org.jboss.arquillian.graphene.spi.enricher.SearchContextTestEnricher;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public abstract class AbstractGrapheneEnricherTest {
    @Mock
    private Instance<ServiceLoader> serviceLoaderInstance;
    @Mock
    private ServiceLoader serviceLoader;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private TestEnricher grapheneEnricher;
    private SearchContextTestEnricher webElementEnricher;
    private SearchContextTestEnricher pageObjectEnricher;
    private SearchContextTestEnricher pageFragmentEnricher;

    @Before
    public void prepareServiceLoader() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        this.grapheneEnricher = new GrapheneEnricher();
        this.webElementEnricher = new WebElementEnricher();
        this.pageObjectEnricher = new PageObjectEnricher();
        this.pageFragmentEnricher = new PageFragmentEnricher();
        Mockito.when((Object)this.serviceLoaderInstance.get()).thenReturn((Object)this.serviceLoader);
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(this.grapheneEnricher));
        Mockito.when((Object)this.serviceLoader.all(SearchContextTestEnricher.class)).thenReturn(Arrays.asList(this.webElementEnricher, this.pageObjectEnricher, this.pageFragmentEnricher));
        for (Object o : Arrays.asList(this.grapheneEnricher, this.webElementEnricher, this.pageObjectEnricher, this.pageFragmentEnricher)) {
            Field serviceLoaderField = o instanceof SearchContextTestEnricher ? AbstractSearchContextEnricher.class.getDeclaredField("serviceLoader") : o.getClass().getDeclaredField("serviceLoader");
            if (!serviceLoaderField.isAccessible()) {
                serviceLoaderField.setAccessible(true);
            }
            serviceLoaderField.set(o, this.serviceLoaderInstance);
        }
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
    }

    protected final TestEnricher getGrapheneEnricher() {
        return this.grapheneEnricher;
    }

    protected final SearchContextTestEnricher getPageFragmentEnricher() {
        return this.pageFragmentEnricher;
    }

    protected final SearchContextTestEnricher getPageObjectEnricher() {
        return this.pageObjectEnricher;
    }

    protected final SearchContextTestEnricher getWebElementEnricher() {
        return this.webElementEnricher;
    }

    protected final Instance<ServiceLoader> getServiceLoader() {
        return this.serviceLoaderInstance;
    }
}

