/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.GraphenePageExtensionsContext;
import org.jboss.arquillian.graphene.context.TestingDriverStub;
import org.jboss.arquillian.graphene.javascript.AbstractJavaScriptTest;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.javascript.MethodName;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistryImpl;
import org.jboss.arquillian.graphene.page.extension.RemotePageExtensionInstallatorProvider;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.WebDriver;

public class TestExecution
extends AbstractJavaScriptTest {
    @Test
    public void test_execution() {
        TestingDriverStub executor = (TestingDriverStub)Mockito.spy((Object)new TestingDriverStub());
        Mockito.when((Object)executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
        GrapheneContext.set((WebDriver)executor);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        GraphenePageExtensionsContext.setRegistry((PageExtensionRegistry)new PageExtensionRegistryImpl());
        GraphenePageExtensionsContext.setInstallatorProvider((PageExtensionInstallatorProvider)new RemotePageExtensionInstallatorProvider(GraphenePageExtensionsContext.getRegistryProxy(), (WebDriver)executor));
        TestingInterface instance = (TestingInterface)JSInterfaceFactory.create(TestingInterface.class);
        instance.method();
        ((TestingDriverStub)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("TestingInterface", "method"), new Object[0]);
    }

    @Test
    public void test_execution_with_named_method() {
        TestingDriverStub executor = (TestingDriverStub)Mockito.spy((Object)new TestingDriverStub());
        Mockito.when((Object)executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
        GrapheneContext.set((WebDriver)executor);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        GraphenePageExtensionsContext.setRegistry((PageExtensionRegistry)new PageExtensionRegistryImpl());
        GraphenePageExtensionsContext.setInstallatorProvider((PageExtensionInstallatorProvider)new RemotePageExtensionInstallatorProvider(GraphenePageExtensionsContext.getRegistryProxy(), (WebDriver)executor));
        TestingInterface instance = (TestingInterface)JSInterfaceFactory.create(TestingInterface.class);
        instance.namedMethod();
        ((TestingDriverStub)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("TestingInterface", "anotherMethodName"), new Object[0]);
    }

    @Test
    public void test_execution_with_base() {
        TestingDriverStub executor = (TestingDriverStub)Mockito.spy((Object)new TestingDriverStub());
        Mockito.when((Object)executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
        GrapheneContext.set((WebDriver)executor);
        GrapheneConfigurationContext.set((GrapheneConfiguration)new GrapheneConfiguration());
        GraphenePageExtensionsContext.setRegistry((PageExtensionRegistry)new PageExtensionRegistryImpl());
        GraphenePageExtensionsContext.setInstallatorProvider((PageExtensionInstallatorProvider)new RemotePageExtensionInstallatorProvider(GraphenePageExtensionsContext.getRegistryProxy(), (WebDriver)executor));
        TestingInterfaceWithBase instance = (TestingInterfaceWithBase)JSInterfaceFactory.create(TestingInterfaceWithBase.class);
        instance.method();
        ((TestingDriverStub)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "method"), new Object[0]);
    }

    @JavaScript(value="base")
    public static interface TestingInterfaceWithBase {
        public void method();
    }

    @JavaScript
    public static interface TestingInterface {
        public void method();

        @MethodName(value="anotherMethodName")
        public void namedMethod();
    }
}

