/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import java.util.Collections;
import junit.framework.Assert;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistryImpl;
import org.jboss.arquillian.graphene.page.extension.RemotePageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.spi.javascript.JavaScript;
import org.jboss.arquillian.graphene.spi.page.PageExtension;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

@RunWith(value=MockitoJUnitRunner.class)
public class RemotePageExtensionInstallatorProviderTestCase {
    @Mock(extraInterfaces={JavascriptExecutor.class})
    private WebDriver driver;

    @Before
    public void prepareDriver() {
        Mockito.when((Object)((JavascriptExecutor)this.driver).executeScript("install", new Object[0])).thenReturn(null);
        Mockito.when((Object)((JavascriptExecutor)this.driver).executeScript("check", new Object[0])).thenReturn((Object)false, new Object[]{true, true});
    }

    @Test
    public void testInstallation() {
        PageExtension pageExtensionMock = (PageExtension)Mockito.mock(PageExtension.class);
        Mockito.when((Object)pageExtensionMock.getExtensionScript()).thenReturn((Object)JavaScript.fromString((String)"install"));
        Mockito.when((Object)pageExtensionMock.getInstallationDetectionScript()).thenReturn((Object)JavaScript.fromString((String)"check"));
        Mockito.when((Object)pageExtensionMock.getRequired()).thenReturn((Object)Collections.EMPTY_LIST);
        Mockito.when((Object)pageExtensionMock.getName()).thenReturn((Object)"mock");
        PageExtensionRegistryImpl registry = new PageExtensionRegistryImpl();
        registry.register(new PageExtension[]{pageExtensionMock});
        RemotePageExtensionInstallatorProvider provider = new RemotePageExtensionInstallatorProvider((PageExtensionRegistry)registry, this.driver);
        Assert.assertFalse((boolean)provider.installator(pageExtensionMock.getName()).isInstalled());
        provider.installator(pageExtensionMock.getName()).install();
        Assert.assertTrue((boolean)provider.installator(pageExtensionMock.getName()).isInstalled());
    }
}

