/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.locator;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.BooleanConditionWrapper;
import org.jboss.arquillian.graphene.condition.StringConditionFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatorElementTextConditionFactory
extends AbstractBooleanConditionFactory<StringConditionFactory>
implements StringConditionFactory<StringConditionFactory> {
    private final By locator;
    protected static final Logger LOGGER = Logger.getLogger(LocatorElementTextConditionFactory.class.getName());

    public LocatorElementTextConditionFactory(By locator) {
        this.locator = locator;
    }

    @Override
    protected StringConditionFactory copy() {
        return new LocatorElementTextConditionFactory(this.locator);
    }

    @Override
    public ExpectedCondition<Boolean> contains(String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("The expected string is null.");
        }
        return new BooleanConditionWrapper(ExpectedConditions.textToBePresentInElement((By)this.locator, (String)expected), this.getNegation(), new Class[0]);
    }

    @Override
    public ExpectedCondition<Boolean> equalTo(final String expected) {
        if (expected == null) {
            throw new IllegalArgumentException("The expected string is null.");
        }
        return new BooleanConditionWrapper(new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String elementText = LocatorElementTextConditionFactory.findElement(LocatorElementTextConditionFactory.this.locator, driver).getText();
                return expected.equals(elementText);
            }
        }, this.getNegation(), new Class[0]);
    }

    private static WebElement findElement(By by, WebDriver driver) {
        try {
            return driver.findElement(by);
        }
        catch (NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            LOGGER.log(Level.FINE, String.format("WebDriverException thrown by findElement(%s)", by), e);
            throw e;
        }
    }
}

