/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.enricher.GrapheneEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.spi.enricher.SearchContextTestEnricher;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.openqa.selenium.SearchContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchContextEnricher
implements SearchContextTestEnricher {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    @Inject
    private static Instance<ServiceLoader> serviceLoader;

    protected static final void enrichRecursively(SearchContext searchContext, Object target) {
        for (TestEnricher enricher : ((ServiceLoader)serviceLoader.get()).all(TestEnricher.class)) {
            if (enricher.getClass().equals(GrapheneEnricher.class)) continue;
            enricher.enrich(target);
        }
        for (TestEnricher enricher : ((ServiceLoader)serviceLoader.get()).all(SearchContextTestEnricher.class)) {
            enricher.enrich(searchContext, target);
        }
    }

    protected final Class<?> getActualType(Field field, Object testCase) {
        String superClassTypeParameterName;
        Type[] superClassActualTypeArguments = this.getSuperClassActualTypeArguments(testCase);
        TypeVariable<?>[] superClassTypeParameters = this.getSuperClassTypeParameters(testCase);
        String fieldParameterTypeName = field.getGenericType().toString();
        int index = Arrays.asList(superClassTypeParameters).indexOf(fieldParameterTypeName);
        for (index = 0; index < superClassTypeParameters.length && !fieldParameterTypeName.equals(superClassTypeParameterName = superClassTypeParameters[index].getName()); ++index) {
        }
        return (Class)superClassActualTypeArguments[index];
    }

    protected final Class<?> getListType(Field listField) throws ClassNotFoundException {
        return Class.forName(listField.getGenericType().toString().split("<")[1].split(">")[0].split("<")[0]);
    }

    protected static final <T> T instantiate(Class<T> clazz, Object ... args) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<T> construtor;
        int i;
        Object[] realArgs;
        Class[] argTypes;
        Class<?> outerClass = clazz.getDeclaringClass();
        if (outerClass == null || Modifier.isStatic(clazz.getModifiers())) {
            argTypes = new Class[args.length];
            realArgs = args;
            for (i = 0; i < args.length; ++i) {
                argTypes[i] = args[i].getClass();
            }
        } else {
            argTypes = new Class[args.length + 1];
            realArgs = new Object[args.length + 1];
            argTypes[0] = outerClass;
            realArgs[0] = AbstractSearchContextEnricher.instantiate(outerClass, new Object[0]);
            for (i = 0; i < args.length; ++i) {
                argTypes[i + 1] = args[i].getClass();
                realArgs[i + 1] = args[i];
            }
        }
        if (!(construtor = ReflectionHelper.hasConstructor(clazz, argTypes) ? clazz.getDeclaredConstructor(argTypes) : ReflectionHelper.getAssignableConstructor(clazz, argTypes)).isAccessible()) {
            construtor.setAccessible(true);
        }
        return construtor.newInstance(realArgs);
    }

    protected static final void setValue(Field field, Object target, Object value) {
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            field.set(target, value);
        }
        catch (Exception ex) {
            throw new GrapheneTestEnricherException("During enriching of " + NEW_LINE + target.getClass() + NEW_LINE + " the field " + NEW_LINE + field + " was not able to be set! Check the cause!", ex);
        }
        if (!accessible) {
            field.setAccessible(false);
        }
    }

    private Type[] getSuperClassActualTypeArguments(Object testCase) {
        Type[] actualTypeArguemnts = ((ParameterizedType)testCase.getClass().getGenericSuperclass()).getActualTypeArguments();
        return actualTypeArguemnts;
    }

    private TypeVariable<?>[] getSuperClassTypeParameters(Object testCase) {
        TypeVariable<Class<?>>[] typeParameters = testCase.getClass().getSuperclass().getTypeParameters();
        return typeParameters;
    }
}

