/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.enricher.exception.PageFragmentInitializationException;
import org.jboss.arquillian.graphene.enricher.findby.FindByUtilities;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.spi.annotations.Root;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFragmentEnricher
extends AbstractSearchContextEnricher {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void enrich(SearchContext searchContext, Object target) {
        List<Field> fields = FindByUtilities.getListOfFieldsAnnotatedWithFindBys(target);
        for (Field field : fields) {
            if (this.isPageFragmentClass(field.getType())) {
                this.setupPageFragment(searchContext, target, field);
                continue;
            }
            try {
                if (!field.getType().isAssignableFrom(List.class) || !this.isPageFragmentClass(this.getListType(field))) continue;
                this.setupPageFragmentList(searchContext, target, field);
            }
            catch (ClassNotFoundException e) {
                throw new PageFragmentInitializationException(e.getMessage(), e);
            }
        }
    }

    protected final boolean isPageFragmentClass(Class<?> clazz) {
        if (Modifier.isInterface(clazz.getModifiers()) || Modifier.isFinal(clazz.getModifiers()) || Modifier.isAbstract(clazz.getModifiers())) {
            return false;
        }
        Class<?> outerClass = clazz.getDeclaringClass();
        if (outerClass == null || Modifier.isStatic(clazz.getModifiers())) {
            return ReflectionHelper.hasConstructor(clazz, new Class[0]);
        }
        return ReflectionHelper.hasConstructor(clazz, outerClass);
    }

    protected final <T> List<T> createPageFragmentList(final Class<T> clazz, final SearchContext searchContext, final By rootBy) {
        List result = (List)GrapheneProxy.getProxyForFutureTarget(new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                List elements = searchContext.findElements(rootBy);
                ArrayList fragments = new ArrayList();
                for (int i = 0; i < elements.size(); ++i) {
                    fragments.add(PageFragmentEnricher.createPageFragment(clazz, WebElementUtils.findElementLazily(rootBy, searchContext, i)));
                }
                return fragments;
            }
        }, List.class, new Class[0]);
        return result;
    }

    public static final <T> T createPageFragment(Class<T> clazz, WebElement root) {
        try {
            T pageFragment = PageFragmentEnricher.instantiate(clazz, new Object[0]);
            List<Field> roots = ReflectionHelper.getFieldsWithAnnotation(clazz, Root.class);
            if (roots.size() > 1) {
                throw new PageFragmentInitializationException("The Page Fragment " + NEW_LINE + pageFragment.getClass() + NEW_LINE + " can not have more than one field annotated with Root annotation!" + "Your fields with @Root annotation: " + roots + NEW_LINE);
            }
            if (roots.size() == 1) {
                PageFragmentEnricher.setValue(roots.get(0), pageFragment, root);
            }
            PageFragmentEnricher.enrichRecursively((SearchContext)root, pageFragment);
            return pageFragment;
        }
        catch (NoSuchMethodException ex) {
            throw new PageFragmentInitializationException(" Check whether declared Page Fragment has no argument constructor!", ex);
        }
        catch (IllegalAccessException ex) {
            throw new PageFragmentInitializationException(" Check whether declared Page Fragment has public no argument constructor!", ex);
        }
        catch (InstantiationException ex) {
            throw new PageFragmentInitializationException(" Check whether you did not declare Page Fragment with abstract type!", ex);
        }
        catch (Exception ex) {
            throw new PageFragmentInitializationException(ex);
        }
    }

    protected final void setupPageFragmentList(SearchContext searchContext, Object target, Field field) throws ClassNotFoundException {
        By rootBy = FindByUtilities.getCorrectBy(field);
        if (rootBy == null) {
            throw new PageFragmentInitializationException("Your declaration of Page Fragment in test " + field.getDeclaringClass().getName() + " is annotated with @FindBy without any " + "parameters, in other words without reference to root of the particular Page Fragment on the page!" + NEW_LINE);
        }
        List<?> pageFragments = this.createPageFragmentList(this.getListType(field), searchContext, rootBy);
        PageFragmentEnricher.setValue(field, target, pageFragments);
    }

    protected final void setupPageFragment(SearchContext searchContext, Object target, Field field) {
        By rootBy = FindByUtilities.getCorrectBy(field);
        if (rootBy == null) {
            throw new PageFragmentInitializationException("Your declaration of Page Fragment in test " + field.getDeclaringClass().getName() + " is annotated with @FindBy without any " + "parameters, in other words without reference to root of the particular Page Fragment on the page!" + NEW_LINE);
        }
        WebElement root = WebElementUtils.findElementLazily(rootBy, searchContext);
        Object pageFragment = PageFragmentEnricher.createPageFragment(field.getType(), root);
        PageFragmentEnricher.setValue(field, target, pageFragment);
    }
}

