/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.WebElementUtils;
import org.jboss.arquillian.graphene.enricher.exception.GrapheneTestEnricherException;
import org.jboss.arquillian.graphene.enricher.findby.FindByUtilities;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebElementWrapperEnricher
extends AbstractSearchContextEnricher {
    public void enrich(final SearchContext searchContext, Object target) {
        List<Field> fields = FindByUtilities.getListOfFieldsAnnotatedWithFindBys(target);
        Iterator<Field> i$ = fields.iterator();
        while (i$.hasNext()) {
            Field field;
            final Field finalField = field = i$.next();
            if (!this.isValidClass(field.getType())) continue;
            final By rootBy = FindByUtilities.getCorrectBy(field);
            try {
                Object component = GrapheneProxy.getProxyForFutureTarget(new GrapheneProxy.FutureTarget(){

                    public Object getTarget() {
                        try {
                            return AbstractSearchContextEnricher.instantiate(finalField.getType(), WebElementUtils.findElementLazily(rootBy, searchContext));
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Can't instantiate the " + finalField.getType());
                        }
                    }
                }, field.getType(), new Class[0]);
                WebElementWrapperEnricher.setValue(field, target, component);
            }
            catch (Exception e) {
                throw new GrapheneTestEnricherException("Can't set a value to the " + target.getClass() + "." + field.getName() + ".", e);
            }
        }
    }

    protected final boolean isValidClass(Class<?> clazz) {
        Class<?> outerClass = clazz.getDeclaringClass();
        if (outerClass == null || Modifier.isStatic(clazz.getModifiers())) {
            return ReflectionHelper.hasConstructor(clazz, WebElement.class);
        }
        return ReflectionHelper.hasConstructor(clazz, outerClass, WebElement.class);
    }
}

