/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.guard;

import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.guard.RequestGuard;
import org.jboss.arquillian.graphene.guard.RequestGuardException;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.page.RequestType;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestGuardFactory {
    private static RequestGuard guard = JSInterfaceFactory.create(RequestGuard.class);
    private static Document document = JSInterfaceFactory.create(Document.class);
    private static DocumentReady documentReady = new DocumentReady();

    public static <T> T guard(T target, final RequestType requestExpected) {
        if (requestExpected == null) {
            throw new IllegalArgumentException("The paremeter [requestExpected] is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("The paremeter [target] is null.");
        }
        GrapheneProxyInstance proxy = GrapheneProxy.isProxyInstance(target) ? (GrapheneProxyInstance)((GrapheneProxyInstance)target).copy() : (GrapheneProxyInstance)GrapheneProxy.getProxyForTarget(target);
        proxy.registerInterceptor(new Interceptor(){

            public Object intercept(InvocationContext context) throws Throwable {
                guard.clearRequestDone();
                Object result = context.invoke();
                long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(GrapheneConfigurationContext.getProxy().getWaitGuardInterval());
                long toSleep = Math.min(GrapheneConfigurationContext.getProxy().getWaitGuardInterval() * 100L, 200L);
                while (System.currentTimeMillis() < timeout) {
                    RequestType requestDone = guard.getRequestDone();
                    if (!requestDone.equals((Object)RequestType.NONE)) {
                        if (requestDone.equals((Object)requestExpected)) {
                            if (requestDone.equals((Object)RequestType.HTTP)) {
                                Graphene.waitModel().withMessage("Document didn't become ready").until(documentReady);
                            }
                            return result;
                        }
                        throw new RequestGuardException(requestExpected, guard.getRequestDone());
                    }
                    try {
                        Thread.sleep(toSleep);
                    }
                    catch (InterruptedException ignored) {}
                }
                if (requestExpected.equals((Object)RequestType.NONE)) {
                    return result;
                }
                throw new RequestGuardException(requestExpected, guard.getRequestDone());
            }
        });
        return (T)proxy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentReady
    implements Predicate<WebDriver> {
        private DocumentReady() {
        }

        public boolean apply(WebDriver arg0) {
            return "complete".equals(document.getReadyState());
        }
    }
}

