/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.shaded.org.objenesis;

import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.graphene.shaded.org.objenesis.Objenesis;
import org.jboss.arquillian.graphene.shaded.org.objenesis.instantiator.ObjectInstantiator;
import org.jboss.arquillian.graphene.shaded.org.objenesis.strategy.InstantiatorStrategy;

public class ObjenesisBase
implements Objenesis {
    protected final InstantiatorStrategy strategy;
    protected Map cache;

    public ObjenesisBase(InstantiatorStrategy strategy) {
        this(strategy, true);
    }

    public ObjenesisBase(InstantiatorStrategy strategy, boolean useCache) {
        if (strategy == null) {
            throw new IllegalArgumentException("A strategy can't be null");
        }
        this.strategy = strategy;
        this.cache = useCache ? new HashMap() : null;
    }

    public String toString() {
        return this.getClass().getName() + " using " + this.strategy.getClass().getName() + (this.cache == null ? " without" : " with") + " caching";
    }

    public Object newInstance(Class clazz) {
        return this.getInstantiatorOf(clazz).newInstance();
    }

    public synchronized ObjectInstantiator getInstantiatorOf(Class clazz) {
        if (this.cache == null) {
            return this.strategy.newInstantiatorOf(clazz);
        }
        ObjectInstantiator instantiator = (ObjectInstantiator)this.cache.get(clazz.getName());
        if (instantiator == null) {
            instantiator = this.strategy.newInstantiatorOf(clazz);
            this.cache.put(clazz.getName(), instantiator);
        }
        return instantiator;
    }
}

