/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.attribute;

import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.AttributeIsPresent;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueContains;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueEqualToIgnoreCase;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueEquals;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueMatches;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class ElementAttributeConditionFactory
extends AbstractBooleanConditionFactory<AttributeConditionFactory>
implements AttributeConditionFactory {
    private WebElement element;
    private String attribute;

    public ElementAttributeConditionFactory(WebElement element, String attribute) {
        if (element == null) {
            throw new IllegalArgumentException("The element can't be null.");
        }
        if (attribute == null) {
            throw new IllegalArgumentException("The attribute can't be null.");
        }
        this.element = element;
        this.attribute = attribute;
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new AttributeIsPresent(this.element, this.attribute, this.getNegation());
    }

    @Override
    protected ElementAttributeConditionFactory copy() {
        ElementAttributeConditionFactory copy = new ElementAttributeConditionFactory(this.element, this.attribute);
        copy.setNegation(this.getNegation());
        return copy;
    }

    @Override
    public ExpectedCondition<Boolean> contains(String expected) {
        return new AttributeValueContains(this.element, this.attribute, expected, this.getNegation());
    }

    @Override
    public ExpectedCondition<Boolean> equalTo(String expected) {
        return new AttributeValueEquals(this.element, this.attribute, expected, this.getNegation());
    }

    @Override
    public ExpectedCondition<Boolean> equalToIgnoreCase(String expected) {
        return new AttributeValueEqualToIgnoreCase(this.element, this.attribute, expected, this.getNegation());
    }

    @Override
    public ExpectedCondition<Boolean> matches(String expected) {
        return new AttributeValueMatches(this.element, this.attribute, expected, this.getNegation());
    }
}

