/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.intercept;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.implementation.bind.annotation.Empty;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.jboss.arquillian.graphene.bytebuddy.MethodInterceptor;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.intercept.ClassImposterizer;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;

public class InterceptorBuilder {
    private Map<Method, List<Interceptor>> interceptors = new HashMap<Method, List<Interceptor>>();

    public <T> T interceptInvocation(Class<T> type, Interceptor interceptor) {
        return ClassImposterizer.INSTANCE.imposterise(new InterceptorImpl(this, interceptor), type, new Class[0]);
    }

    private void registerMethodInterceptor(Method method, Interceptor interceptor) {
        List<Interceptor> list = this.interceptors.get(method);
        if (list == null) {
            list = new LinkedList<Interceptor>();
            this.interceptors.put(method, list);
        }
        list.add(interceptor);
    }

    public Interceptor build() {
        return new Interceptor(){
            final Map<Method, List<Interceptor>> interceptors;
            {
                this.interceptors = new HashMap<Method, List<Interceptor>>(InterceptorBuilder.this.interceptors);
            }

            @Override
            public Object intercept(final InvocationContext originalContext) throws Throwable {
                Iterator iterator;
                Collection interceptors = this.interceptors.get(originalContext.getMethod());
                if (interceptors != null && (iterator = interceptors.iterator()).hasNext()) {
                    Interceptor interceptor = (Interceptor)iterator.next();
                    return interceptor.intercept(new InvocationContext(){

                        @Override
                        public Object invoke() throws Throwable {
                            if (iterator.hasNext()) {
                                return ((Interceptor)iterator.next()).intercept(this);
                            }
                            return originalContext.invoke();
                        }

                        @Override
                        public Object getTarget() {
                            return originalContext.getTarget();
                        }

                        @Override
                        public Object getProxy() {
                            return originalContext.getProxy();
                        }

                        @Override
                        public Method getMethod() {
                            return originalContext.getMethod();
                        }

                        @Override
                        public Object[] getArguments() {
                            return originalContext.getArguments();
                        }

                        @Override
                        public GrapheneContext getGrapheneContext() {
                            return originalContext.getGrapheneContext();
                        }
                    });
                }
                return originalContext.invoke();
            }

            @Override
            public int getPrecedence() {
                return 0;
            }
        };
    }

    public static class InterceptorImpl
    implements MethodInterceptor {
        private final InterceptorBuilder builder;
        private final Interceptor interceptor;

        public InterceptorImpl(InterceptorBuilder builder, Interceptor interceptor) {
            this.builder = builder;
            this.interceptor = interceptor;
        }

        @RuntimeType
        public static Object intercept(@Origin Method method, @FieldValue(value="__interceptor") MethodInterceptor interceptor, @Empty Object defaultValue) throws Throwable {
            InterceptorImpl impl = (InterceptorImpl)interceptor;
            impl.builder.registerMethodInterceptor(method, impl.interceptor);
            return defaultValue;
        }
    }
}

