/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.location.decider;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.graphene.location.ContextRootStore;
import org.jboss.arquillian.graphene.location.exception.LocationException;
import org.jboss.arquillian.graphene.spi.location.LocationDecider;
import org.jboss.arquillian.graphene.spi.location.Scheme;

public class HTTPLocationDecider
implements LocationDecider {
    private final Scheme scheme = new Scheme.HTTP();
    @Inject
    private Instance<ContextRootStore> locationStore;

    public Scheme canDecide() {
        return this.scheme;
    }

    public String decide(String location) {
        URI uri = null;
        try {
            uri = new URI(location);
            if (!uri.isAbsolute()) {
                return this.getURLFromLocationWithRoot(location);
            }
        }
        catch (URISyntaxException e) {
            return this.getURLFromLocationWithRoot(location);
        }
        try {
            return uri.toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            throw new LocationException(String.format("Location you want to decide (%s) can not be converted to URL.", location));
        }
    }

    private String getURLFromLocationWithRoot(String location) {
        URL contextRoot = ((ContextRootStore)this.locationStore.get()).getURL();
        if (contextRoot != null) {
            try {
                return new URL(contextRoot, location).toExternalForm();
            }
            catch (MalformedURLException ex) {
                throw new LocationException("URL to construct is malformed.", ex.getCause());
            }
        }
        throw new LocationException(String.format("The location %s is not valid URI and no contextRoot was discovered to treat it as relative URL", location));
    }
}

