/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.io.ObjectInputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;

public class ServletMethodExecutor
implements ContainerMethodExecutor {
    public static final String ARQUILLIAN_SERVLET_NAME = "ArquillianServletRunner";
    public static final String ARQUILLIAN_SERVLET_MAPPING = "/ArquillianServletRunner";
    private URI baseURI;

    public ServletMethodExecutor(URI baseURI) {
        this.baseURI = baseURI;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor must be specified");
        }
        Class<?> testClass = testMethodExecutor.getInstance().getClass();
        String url = this.baseURI.toASCIIString() + ARQUILLIAN_SERVLET_MAPPING + "?outputMode=serializedObject&className=" + testClass.getName() + "&methodName=" + testMethodExecutor.getMethod().getName();
        try {
            return this.execute(url);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error launching test " + testClass.getName() + " " + testMethodExecutor.getMethod(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult execute(String url) throws Exception {
        long timeoutTime = System.currentTimeMillis() + 1000L;
        boolean interrupted = false;
        while (timeoutTime > System.currentTimeMillis()) {
            URLConnection connection = new URL(url).openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                throw new IllegalStateException("Not an http connection! " + connection);
            }
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setUseCaches(false);
            httpConnection.setDefaultUseCaches(false);
            try {
                httpConnection.connect();
                if (httpConnection.getResponseCode() == 200) {
                    Object o;
                    ObjectInputStream ois = new ObjectInputStream(httpConnection.getInputStream());
                    try {
                        o = ois.readObject();
                    }
                    finally {
                        ois.close();
                    }
                    if (!(o instanceof TestResult)) {
                        throw new IllegalStateException("Error reading test results - expected a TestResult but got " + o);
                    }
                    TestResult testResult = (TestResult)o;
                    return testResult;
                }
                if (httpConnection.getResponseCode() != 404) {
                    throw new IllegalStateException("Error launching test at " + url + ". " + "Got " + httpConnection.getResponseCode() + " (" + httpConnection.getResponseMessage() + ")");
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            finally {
                httpConnection.disconnect();
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        throw new IllegalStateException("Error launching test at " + url + ". Kept on getting 404s.");
    }
}

