/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet.v_2_5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.arquillian.protocol.servlet.Processor;
import org.jboss.arquillian.protocol.servlet.v_2_5.ProtocolDeploymentAppender;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.arquillian.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.ApplicationDescriptor;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;

public class ServletProtocolDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        WebArchive protocol = new ProtocolDeploymentAppender().createAuxiliaryArchive();
        Archive applicationArchive = testDeployment.getApplicationArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        Processor processor = new Processor(testDeployment, processors);
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((EnterpriseArchive)EnterpriseArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        if (WebArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((WebArchive)WebArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        if (JavaArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        throw new IllegalArgumentException(ServletProtocolDeploymentPackager.class.getName() + " can not handle archive of type " + applicationArchive.getClass().getName());
    }

    private Archive<?> handleArchive(WebArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol, Processor processor) {
        ArchivePath webXmlPath = ArchivePaths.create((String)"WEB-INF/web.xml");
        if (applicationArchive.contains(webXmlPath)) {
            WebAppDescriptor applicationWebXml = (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).from(applicationArchive.get(webXmlPath).getAsset().openStream());
            applicationArchive.setWebXML((Asset)new StringAsset(this.mergeWithDescriptor(applicationWebXml).exportAsString()));
            applicationArchive.merge((Archive)protocol, Filters.exclude((String)".*web\\.xml.*"));
        } else {
            applicationArchive.merge((Archive)protocol);
        }
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        processor.process((Archive<?>)applicationArchive);
        return applicationArchive;
    }

    private Archive<?> handleArchive(JavaArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol, Processor processor) {
        return this.handleArchive((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"test.ear")).addAsModule((Archive)applicationArchive), auxiliaryArchives, protocol, processor);
    }

    private Archive<?> handleArchive(EnterpriseArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol, Processor processor) {
        Map applicationArchiveWars = applicationArchive.getContent(Filters.include((String)".*\\.war"));
        if (applicationArchiveWars.size() == 1) {
            Asset warAsset = ((Node)applicationArchiveWars.values().iterator().next()).getAsset();
            if (warAsset instanceof ArchiveAsset) {
                ArchiveAsset warArchiveAsset = (ArchiveAsset)warAsset;
                this.handleArchive((WebArchive)warArchiveAsset.getArchive().as(WebArchive.class), new ArrayList(), protocol, processor);
            }
        } else {
            if (applicationArchiveWars.size() > 1) {
                throw new UnsupportedOperationException("Multiple WebArchives found in " + applicationArchive.getName() + ". Can not determine which to enrich");
            }
            applicationArchive.addAsModule(protocol.setWebXML((Asset)new StringAsset(this.createNewDescriptor().exportAsString())));
            ArchivePath applicationXmlPath = ArchivePaths.create((String)"META-INF/application.xml");
            if (applicationArchive.contains(applicationXmlPath)) {
                ApplicationDescriptor applicationXml = (ApplicationDescriptor)Descriptors.importAs(ApplicationDescriptor.class).from(applicationArchive.get(applicationXmlPath).getAsset().openStream());
                applicationXml.webModule(protocol.getName(), protocol.getName());
                applicationArchive.setApplicationXML((Asset)new StringAsset(applicationXml.exportAsString()));
            }
            processor.process((Archive<?>)protocol);
        }
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        return applicationArchive;
    }

    private WebAppDescriptor createNewDescriptor() {
        return this.mergeWithDescriptor(this.getDefaultDescriptor());
    }

    private WebAppDescriptor getDefaultDescriptor() {
        return ((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).version("2.5").displayName("Arquillian Servlet 2.5 Protocol");
    }

    private WebAppDescriptor mergeWithDescriptor(WebAppDescriptor descriptor) {
        descriptor.servlet("ArquillianServletRunner", "org.jboss.arquillian.protocol.servlet.runner.ServletTestRunner", new String[]{"/ArquillianServletRunner"});
        return descriptor;
    }
}

