/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet.v_3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.arquillian.protocol.servlet.Processor;
import org.jboss.arquillian.protocol.servlet.v_3.ProtocolDeploymentAppender;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.arquillian.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.ee.application.ApplicationDescriptor;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;

public class ServletProtocolDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        JavaArchive protocol = new ProtocolDeploymentAppender().createAuxiliaryArchive();
        Archive applicationArchive = testDeployment.getApplicationArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        Processor processor = new Processor(testDeployment, processors);
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((EnterpriseArchive)EnterpriseArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        if (WebArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((WebArchive)WebArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        if (JavaArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        throw new IllegalArgumentException(ServletProtocolDeploymentPackager.class.getName() + " can not handle archive of type " + applicationArchive.getClass().getName());
    }

    private Archive<?> handleArchive(WebArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, JavaArchive protocol, Processor processor) {
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        if (protocol != null) {
            applicationArchive.addAsLibrary((Archive)protocol);
        }
        processor.process((Archive<?>)applicationArchive);
        return applicationArchive;
    }

    private Archive<?> handleArchive(JavaArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, JavaArchive protocol, Processor processor) {
        return this.handleArchive((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"test.war")).addAsLibrary((Archive)applicationArchive), auxiliaryArchives, protocol, processor);
    }

    private Archive<?> handleArchive(EnterpriseArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, JavaArchive protocol, Processor processor) {
        Map applicationArchiveWars = applicationArchive.getContent(Filters.include((String)".*\\.war"));
        if (applicationArchiveWars.size() == 1) {
            Asset warAsset = ((Node)applicationArchiveWars.values().iterator().next()).getAsset();
            if (warAsset instanceof ArchiveAsset) {
                ArchiveAsset warArchiveAsset = (ArchiveAsset)warAsset;
                this.handleArchive((WebArchive)warArchiveAsset.getArchive().as(WebArchive.class), new ArrayList(), protocol, processor);
            }
        } else {
            if (applicationArchiveWars.size() > 1) {
                throw new UnsupportedOperationException("Multiple WebArchives found in " + applicationArchive.getName() + ". Can not determine which to enrich");
            }
            Archive<?> wrappedWar = this.handleArchive(protocol, new ArrayList(), null, processor);
            applicationArchive.addAsModule(wrappedWar);
            ArchivePath applicationXmlPath = ArchivePaths.create((String)"META-INF/application.xml");
            if (applicationArchive.contains(applicationXmlPath)) {
                ApplicationDescriptor applicationXml = (ApplicationDescriptor)Descriptors.importAs(ApplicationDescriptor.class).from(applicationArchive.get(applicationXmlPath).getAsset().openStream());
                applicationXml.webModule(wrappedWar.getName(), wrappedWar.getName());
                applicationArchive.setApplicationXML((Asset)new StringAsset(applicationXml.exportAsString()));
            }
        }
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        return applicationArchive;
    }
}

