/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.testenricher.osgi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleContextProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class OSGiTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(OSGiTestEnricher.class.getName());

    public void enrich(Object testCase) {
        BundleContext bundleContext = BundleContextProvider.getBundleContext();
        if (bundleContext == null) {
            log.fine("System bundle context not available");
            return;
        }
        Class<?> testClass = testCase.getClass();
        for (Field field : testClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            if (field.getType().isAssignableFrom(BundleContext.class)) {
                this.injectBundleContext(testCase, field);
                continue;
            }
            if (field.getType().isAssignableFrom(Bundle.class)) {
                this.injectBundle(testCase, field);
                continue;
            }
            if (field.getType().isAssignableFrom(PackageAdmin.class)) {
                this.injectPackageAdmin(testCase, field);
                continue;
            }
            if (!field.getType().isAssignableFrom(StartLevel.class)) continue;
            this.injectStartLevel(testCase, field);
        }
        for (AccessibleObject accessibleObject : testClass.getDeclaredMethods()) {
            Deployment andep;
            if (!accessibleObject.isAnnotationPresent(Deployment.class) || !(andep = ((Method)accessibleObject).getAnnotation(Deployment.class)).managed() || !andep.testable() || !accessibleObject.isAnnotationPresent(StartLevelAware.class)) continue;
            int bundleStartLevel = ((Method)accessibleObject).getAnnotation(StartLevelAware.class).startLevel();
            StartLevel startLevel = this.getStartLevel();
            Bundle bundle = this.getBundle(testCase);
            log.fine("Setting bundle start level of " + bundle + " to: " + bundleStartLevel);
            startLevel.setBundleStartLevel(bundle, bundleStartLevel);
        }
    }

    public Object[] resolve(Method method) {
        return null;
    }

    private void injectBundleContext(Object testCase, Field field) {
        try {
            BundleContext context = BundleContextProvider.getBundleContext();
            log.warning("Deprecated @Inject BundleContext, use @ArquillianResource BundleContext");
            field.set(testCase, context);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject BundleContext", ex);
        }
    }

    private void injectBundle(Object testCase, Field field) {
        try {
            Bundle bundle = this.getBundle(testCase);
            log.warning("Deprecated @Inject Bundle, use @ArquillianResource Bundle");
            field.set(testCase, bundle);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject Bundle", ex);
        }
    }

    private void injectPackageAdmin(Object testCase, Field field) {
        try {
            PackageAdmin packageAdmin = this.getPackageAdmin();
            log.warning("Deprecated @Inject PackageAdmin, use @ArquillianResource PackageAdmin");
            field.set(testCase, packageAdmin);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject PackageAdmin", ex);
        }
    }

    private void injectStartLevel(Object testCase, Field field) {
        try {
            StartLevel startLevel = this.getStartLevel();
            log.warning("Deprecated @Inject StartLevel, use @ArquillianResource StartLevel");
            field.set(testCase, startLevel);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot inject StartLevel", ex);
        }
    }

    private PackageAdmin getPackageAdmin() {
        BundleContext context = BundleContextProvider.getBundleContext();
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(sref);
        return packageAdmin;
    }

    private StartLevel getStartLevel() {
        BundleContext context = BundleContextProvider.getBundleContext();
        ServiceReference sref = context.getServiceReference(StartLevel.class.getName());
        StartLevel startLevel = (StartLevel)context.getService(sref);
        return startLevel;
    }

    private Bundle getBundle(Object testCase) {
        ClassLoader classLoader;
        Bundle bundle = BundleAssociation.getBundle();
        if (bundle == null && (classLoader = testCase.getClass().getClassLoader()) instanceof BundleReference) {
            BundleReference bref = (BundleReference)classLoader;
            bundle = bref.getBundle();
        }
        return bundle;
    }
}

