/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.as.server.deployment.SetupAction;

public class ContextManager {
    private final List<SetupAction> setupActions;

    ContextManager(List<SetupAction> setupActions) {
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>(setupActions);
        Collections.sort(actions, new Comparator<SetupAction>(){

            @Override
            public int compare(SetupAction arg0, SetupAction arg1) {
                return arg0.priority() > arg1.priority() ? -1 : (arg0.priority() == arg1.priority() ? 0 : 1);
            }
        });
        this.setupActions = Collections.unmodifiableList(actions);
    }

    public void setup(Map<String, Object> properties) {
        ArrayList<SetupAction> sucessfulActions = new ArrayList<SetupAction>();
        for (SetupAction action : this.setupActions) {
            try {
                action.setup(properties);
                sucessfulActions.add(action);
            }
            catch (Throwable e) {
                for (SetupAction s : sucessfulActions) {
                    try {
                        s.teardown(properties);
                    }
                    catch (Throwable t) {}
                }
                throw new RuntimeException(e);
            }
        }
    }

    public void teardown(Map<String, Object> properties) {
        Throwable exceptionToThrow = null;
        ListIterator<SetupAction> itr = this.setupActions.listIterator(this.setupActions.size());
        while (itr.hasPrevious()) {
            SetupAction action = itr.previous();
            try {
                action.teardown(properties);
            }
            catch (Throwable e) {
                if (exceptionToThrow != null) continue;
                exceptionToThrow = e;
            }
        }
        if (exceptionToThrow != null) {
            throw new RuntimeException(exceptionToThrow);
        }
    }
}

