/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.parser;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;

class ArquillianProviders {
    static final String RESOURCE_NAME = ArquillianProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ArquillianProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("arquillian"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set("urn:jboss:domain:arquillian:1.0");
            subsystem.get("attributes").setEmptyObject();
            subsystem.get("children").setEmptyObject();
            subsystem.get("operations");
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ArquillianProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("operation-name").set("add");
            node.get("description").set(bundle.getString("arquillian.add"));
            node.get("reply-properties").setEmptyObject();
            node.get("request-properties").setEmptyObject();
            return node;
        }
    };

    ArquillianProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

