/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ArquillianDependencyProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier ARQUILLIAN_JUNIT_ID = ModuleIdentifier.create((String)"org.jboss.arquillian.junit");
    private static ModuleIdentifier SHRINKWRAP_ID = ModuleIdentifier.create((String)"org.jboss.shrinkwrap.api");
    private static ModuleIdentifier JUNIT_ID = ModuleIdentifier.create((String)"org.junit");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (deploymentUnit.getAttachment(ArquillianConfig.KEY) != null) {
            this.addDepdenency(moduleSpecification, moduleLoader, ARQUILLIAN_JUNIT_ID);
            this.addDepdenency(moduleSpecification, moduleLoader, SHRINKWRAP_ID);
            this.addDepdenency(moduleSpecification, moduleLoader, JUNIT_ID);
        }
    }

    private void addDepdenency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

