/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.osgi.deployment.BundleInstallService;
import org.jboss.as.osgi.deployment.OSGiDeploymentAttachment;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;

public class ArquillianDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"arquillian", "deployment", "tracker"});

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ArquillianConfig arqConfig = (ArquillianConfig)phaseContext.getDeploymentUnit().getAttachment(ArquillianConfig.KEY);
        if (arqConfig == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        DeploymentTrackerService tracker = new DeploymentTrackerService(arqConfig);
        ServiceBuilder serviceBuilder = serviceTarget.addService(SERVICE_NAME_BASE.append(new String[]{phaseContext.getDeploymentUnit().getName()}), (Service)tracker);
        serviceBuilder.addDependency(ArquillianService.SERVICE_NAME, ArquillianService.class, (Injector)tracker.injectedArquillianService);
        Deployment osgiDeployment = OSGiDeploymentAttachment.getDeployment((DeploymentUnit)phaseContext.getDeploymentUnit());
        if (osgiDeployment != null) {
            ServiceName serviceName = BundleInstallService.getServiceName((String)phaseContext.getDeploymentUnit().getName());
            serviceBuilder.addDependency(serviceName);
            osgiDeployment.setAutoStart(false);
        }
        serviceBuilder.install();
    }

    public void undeploy(DeploymentUnit context) {
        ServiceName serviceName = SERVICE_NAME_BASE.append(new String[]{context.getName()});
        ServiceController controller = context.getServiceRegistry().getService(serviceName);
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    private class DeploymentTrackerService
    implements Service<Object> {
        private final ArquillianConfig arqConfig;
        private final InjectedValue<ArquillianService> injectedArquillianService = new InjectedValue();

        public DeploymentTrackerService(ArquillianConfig arqConfig) {
            this.arqConfig = arqConfig;
        }

        public void start(StartContext context) throws StartException {
            ArquillianService service = (ArquillianService)this.injectedArquillianService.getValue();
            service.registerDeployment(this.arqConfig);
        }

        public void stop(StopContext context) {
            ArquillianService service = (ArquillianService)this.injectedArquillianService.getValue();
            service.unregisterDeployment(this.arqConfig);
        }

        public Object getValue() throws IllegalStateException {
            return null;
        }
    }
}

