/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class DeleteJmsQueueHandler
extends BatchModeCommandHandler {
    private final ArgumentWithValue profile;
    private final ArgumentWithValue name;

    public DeleteJmsQueueHandler() {
        super("delete-jms-queue", true);
        SimpleArgumentTabCompleter argsCompleter = (SimpleArgumentTabCompleter)this.getArgumentCompleter();
        this.profile = new ArgumentWithValue((CommandLineCompleter)new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), new String[]{"--profile"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        argsCompleter.addArgument(this.profile);
        this.name = new ArgumentWithValue(true, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                String profileArg;
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                if (!ctx.isDomainMode()) {
                    profileArg = null;
                } else {
                    profileArg = DeleteJmsQueueHandler.this.profile.getValue(ctx.getParsedArguments());
                    if (profileArg == null) {
                        return Collections.emptyList();
                    }
                }
                return Util.getJmsResources(ctx.getModelControllerClient(), profileArg, "queue");
            }
        }), 0, new String[]{"--name"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (ctx.isDomainMode() && !DeleteJmsQueueHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        argsCompleter.addArgument(this.name);
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (OperationFormatException e1) {
            ctx.printLine(e1.getLocalizedMessage());
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine("Failed to delete queue: " + Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("Successfully removed queue. ");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        String name;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(ctx.getParsedArguments());
            if (profile == null) {
                throw new OperationFormatException("Required argument --profile is missing.");
            }
            builder.addNode("profile", profile);
        }
        try {
            name = this.name.getValue(ctx.getParsedArguments());
        }
        catch (IllegalArgumentException e) {
            throw new OperationFormatException("Missing required name argument.");
        }
        builder.addNode("subsystem", "jms");
        builder.addNode("queue", name);
        builder.setOperationName("remove");
        return builder.buildRequest();
    }
}

