/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.SimpleArgumentTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class UndeployHandler
extends BatchModeCommandHandler {
    private final ArgumentWithoutValue l;
    private final ArgumentWithValue name;
    private final ArgumentWithValue serverGroups;
    private final ArgumentWithoutValue allRelevantServerGroups;
    private final ArgumentWithoutValue keepContent;

    public UndeployHandler() {
        super("undeploy", true);
        SimpleArgumentTabCompleter argsCompleter = (SimpleArgumentTabCompleter)this.getArgumentCompleter();
        this.l = new ArgumentWithoutValue("-l");
        this.l.setExclusive(true);
        argsCompleter.addArgument(this.l);
        this.name = new ArgumentWithValue(false, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }, 0, "--name");
        this.name.addCantAppearAfter(this.l);
        argsCompleter.addArgument(this.name);
        this.allRelevantServerGroups = new ArgumentWithoutValue(new String[]{"--all-relevant-server-groups"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        argsCompleter.addArgument(this.allRelevantServerGroups);
        this.allRelevantServerGroups.addRequiredPreceding(this.name);
        this.serverGroups = new ArgumentWithValue(false, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int result;
                String chunk;
                int lastGroupIndex;
                if (buffer.isEmpty()) {
                    candidates.addAll(Util.getServerGroups(ctx.getModelControllerClient()));
                    Collections.sort(candidates);
                    return 0;
                }
                List<String> allGroups = Util.getServerGroups(ctx.getModelControllerClient());
                String[] groups = buffer.split(",+");
                if (buffer.charAt(buffer.length() - 1) == ',') {
                    lastGroupIndex = groups.length;
                    chunk = null;
                } else {
                    lastGroupIndex = groups.length - 1;
                    chunk = groups[groups.length - 1];
                }
                for (int i = 0; i < lastGroupIndex; ++i) {
                    allGroups.remove(groups[i]);
                }
                if (chunk == null) {
                    candidates.addAll(allGroups);
                    result = buffer.length();
                } else {
                    for (String group : allGroups) {
                        if (!group.startsWith(chunk)) continue;
                        candidates.add(group);
                    }
                    result = buffer.lastIndexOf(44) + 1;
                }
                Collections.sort(candidates);
                return result;
            }
        }, new String[]{"--server-groups"}){

            @Override
            public boolean canAppearNext(CommandContext ctx) {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.serverGroups.addRequiredPreceding(this.name);
        argsCompleter.addArgument(this.serverGroups);
        this.serverGroups.addCantAppearAfter(this.allRelevantServerGroups);
        this.allRelevantServerGroups.addCantAppearAfter(this.serverGroups);
        this.keepContent = new ArgumentWithoutValue("--keep-content");
        argsCompleter.addArgument(this.keepContent);
        this.keepContent.addRequiredPreceding(this.name);
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        ModelControllerClient client = ctx.getModelControllerClient();
        ParsedArguments args = ctx.getParsedArguments();
        boolean l = this.l.isPresent(args);
        if (!args.hasArguments() || l) {
            this.printList(ctx, Util.getDeployments(client), l);
            return;
        }
        String name = this.name.getValue(ctx.getParsedArguments());
        if (name == null) {
            this.printList(ctx, Util.getDeployments(client), l);
            return;
        }
        try {
            request = this.buildRequest(ctx);
        }
        catch (OperationFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
            return;
        }
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Undeploy failed: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine("Undeploy failed: " + Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("Successfully undeployed " + name + ".");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        DefaultOperationRequestBuilder builder;
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ParsedArguments args = ctx.getParsedArguments();
        String name = this.name.getValue(args);
        if (name == null) {
            throw new OperationFormatException("Required argument name are missing.");
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        boolean keepContent = this.keepContent.isPresent(args);
        if (ctx.isDomainMode()) {
            String serverGroupsStr;
            List<Object> serverGroups = this.allRelevantServerGroups.isPresent(args) ? (keepContent ? Util.getAllEnabledServerGroups(name, client) : Util.getAllReferencingServerGroups(name, client)) : ((serverGroupsStr = this.serverGroups.getValue(args)) == null ? Collections.emptyList() : Arrays.asList(serverGroupsStr.split(",")));
            if (serverGroups.isEmpty()) {
                if (keepContent) {
                    throw new OperationFormatException("None server group is specified or available.");
                }
            } else {
                ModelNode groupStep;
                for (String group : serverGroups) {
                    groupStep = Util.configureDeploymentOperation("undeploy", name, group);
                    steps.add(groupStep);
                }
                for (String group : serverGroups) {
                    groupStep = Util.configureDeploymentOperation("remove", name, group);
                    steps.add(groupStep);
                }
            }
        } else if (Util.isDeployedAndEnabledInStandalone(name, client)) {
            builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("undeploy");
            builder.addNode("deployment", name);
            steps.add(builder.buildRequest());
        }
        if (!keepContent) {
            builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("remove");
            builder.addNode("deployment", name);
            steps.add(builder.buildRequest());
        }
        return composite;
    }
}

