/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;

public class ArgumentWithoutValue
implements CommandArgument {
    protected final int index;
    protected final String defaultName;
    protected final String[] names;
    protected List<CommandArgument> requiredPreceding;
    protected List<CommandArgument> cantAppearAfter = Collections.emptyList();
    protected boolean exclusive;

    public ArgumentWithoutValue(String ... names) {
        this(-1, names);
    }

    public ArgumentWithoutValue(int index, String ... names) {
        if (names == null || names.length < 1) {
            throw new IllegalArgumentException("There must be at least one non-null default name.");
        }
        this.defaultName = names[0];
        if (this.defaultName == null) {
            throw new IllegalArgumentException("There must be at least one non-null default name.");
        }
        this.names = names;
        this.index = index;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = true;
    }

    public void addRequiredPreceding(CommandArgument arg) {
        if (arg == null) {
            throw new IllegalArgumentException("The argument is null.");
        }
        if (this.requiredPreceding == null) {
            this.requiredPreceding = Collections.singletonList(arg);
            return;
        }
        if (this.requiredPreceding.size() == 1) {
            this.requiredPreceding = new ArrayList<CommandArgument>(this.requiredPreceding);
        }
        this.requiredPreceding.add(arg);
    }

    public void addCantAppearAfter(CommandArgument arg) {
        if (this.cantAppearAfter.isEmpty()) {
            this.cantAppearAfter = new ArrayList<CommandArgument>();
        }
        this.cantAppearAfter.add(arg);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public CommandLineCompleter getValueCompleter() {
        return null;
    }

    @Override
    public String getValue(ParsedArguments args) {
        return null;
    }

    @Override
    public boolean isPresent(ParsedArguments args) {
        if (!args.hasArguments()) {
            return false;
        }
        if (this.index >= 0 && this.index < args.getOtherArguments().size()) {
            return true;
        }
        if (this.names != null && this.names.length > 0) {
            if (this.names.length == 1) {
                return args.hasArgument(this.names[0]);
            }
            for (String name : this.names) {
                if (!args.hasArgument(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public boolean canAppearNext(CommandContext ctx) {
        ParsedArguments args = ctx.getParsedArguments();
        if (this.exclusive) {
            return !args.hasArguments();
        }
        if (this.isPresent(args)) {
            return false;
        }
        for (CommandArgument arg : this.cantAppearAfter) {
            if (!arg.isPresent(args)) continue;
            return false;
        }
        if (this.requiredPreceding != null) {
            for (CommandArgument arg : this.requiredPreceding) {
                if (!arg.isPresent(args)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueRequired() {
        return false;
    }
}

