/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.parsing.ParsingContext;
import org.jboss.as.cli.operation.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.operation.parsing.StateParser;
import org.jboss.as.cli.parsing.ArgumentListState;

public class CommandLineParser {
    public static void parse(String commandLine, final CallbackHandler argHandler) throws CommandLineException {
        if (commandLine == null || commandLine.isEmpty()) {
            return;
        }
        ParsingStateCallbackHandler callbackHandler = new ParsingStateCallbackHandler(){
            private String name;
            private int nameStart = -1;
            final StringBuilder buffer = new StringBuilder();
            private int valueStart = -1;

            @Override
            public void enteredState(ParsingContext ctx) throws OperationFormatException {
                String id = ctx.getState().getId();
                if ("ARG".equals(id)) {
                    this.nameStart = ctx.getLocation();
                } else if ("ARG_VALUE".equals(id)) {
                    if (this.buffer.length() > 0) {
                        this.name = this.buffer.toString();
                        this.buffer.setLength(0);
                        this.valueStart = ctx.getLocation() + 1;
                    } else {
                        this.valueStart = ctx.getLocation();
                    }
                }
            }

            @Override
            public void leavingState(ParsingContext ctx) throws OperationFormatException {
                String id = ctx.getState().getId();
                if ("ARG".equals(id)) {
                    if (this.buffer.length() > 0) {
                        int endIndex = ctx.getLocation();
                        argHandler.argument(this.buffer.toString(), this.nameStart, null, -1, endIndex);
                    }
                    this.buffer.setLength(0);
                    this.name = null;
                    this.nameStart = -1;
                } else if ("ARG_VALUE".equals(id)) {
                    int endIndex = ctx.getLocation();
                    argHandler.argument(this.name, this.nameStart, this.buffer.toString(), this.valueStart, endIndex);
                    this.buffer.setLength(0);
                    this.valueStart = -1;
                }
            }

            @Override
            public void character(ParsingContext ctx) throws OperationFormatException {
                this.buffer.append(ctx.getCharacter());
            }
        };
        StateParser.parse(commandLine, callbackHandler, ArgumentListState.INSTANCE);
    }

    public static void main(String[] args) throws Exception {
        String line = "../../../../my\\ dir/";
        System.out.println("../../../../my\\ dir/");
        CommandLineParser.parse("../../../../my\\ dir/", new CallbackHandler(){

            @Override
            public void argument(String name, int nameStart, String value, int valueStart, int end) {
                StringBuilder buf = new StringBuilder();
                buf.append("arg[").append(nameStart).append('/').append(valueStart).append('-').append(end).append("]: ");
                if (name == null) {
                    buf.append('\'').append("../../../../my\\ dir/".substring(valueStart, end)).append('\'');
                } else if (value == null) {
                    buf.append('\'').append("../../../../my\\ dir/".substring(nameStart, end)).append('\'');
                } else {
                    buf.append('\'').append("../../../../my\\ dir/".substring(nameStart, valueStart)).append("../../../../my\\ dir/".substring(valueStart, end)).append('\'');
                }
                System.out.println(buf.toString());
            }
        });
    }

    public static interface CallbackHandler {
        public void argument(String var1, int var2, String var3, int var4, int var5);
    }
}

