/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.infinispan.ClassLoaderAwareCache;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

public class DefaultEmbeddedCacheManager
implements EmbeddedCacheManager {
    private static final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    private final String defaultCache;
    private final EmbeddedCacheManager container;

    public DefaultEmbeddedCacheManager(EmbeddedCacheManager container, String defaultCache) {
        this.container = container;
        this.defaultCache = defaultCache;
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache(this.defaultCache);
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName, boolean start) {
        ContextClassLoaderSwitcher.SwitchContext context = start ? switcher.getSwitchContext(DefaultEmbeddedCacheManager.class.getClassLoader()) : null;
        try {
            Cache cache = this.container.getCache(this.getCacheName(cacheName), start);
            DelegatingCache delegatingCache = cache != null ? new DelegatingCache(cache) : null;
            return delegatingCache;
        }
        finally {
            if (context != null) {
                context.reset();
            }
        }
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void addListener(Object listener) {
        this.container.addListener(listener);
    }

    public void removeListener(Object listener) {
        this.container.removeListener(listener);
    }

    public Set<Object> getListeners() {
        return this.container.getListeners();
    }

    public Configuration defineConfiguration(String cacheName, Configuration configurationOverride) {
        return this.defineConfiguration(cacheName, this.defaultCache, configurationOverride);
    }

    public Configuration defineConfiguration(String cacheName, String templateCacheName, Configuration configurationOverride) {
        return this.container.defineConfiguration(this.getCacheName(cacheName), this.getCacheName(templateCacheName), configurationOverride);
    }

    public String getClusterName() {
        return this.container.getClusterName();
    }

    public List<Address> getMembers() {
        return this.container.getMembers();
    }

    public Address getAddress() {
        return this.container.getAddress();
    }

    public Address getCoordinator() {
        return this.container.getCoordinator();
    }

    public boolean isCoordinator() {
        return this.container.isCoordinator();
    }

    public ComponentStatus getStatus() {
        return this.container.getStatus();
    }

    public GlobalConfiguration getGlobalConfiguration() {
        return this.container.getGlobalConfiguration();
    }

    public Configuration getDefaultConfiguration() {
        return this.container.getDefaultConfiguration();
    }

    public Set<String> getCacheNames() {
        HashSet<String> names = new HashSet<String>(this.container.getCacheNames());
        names.add(this.defaultCache);
        return names;
    }

    public boolean isRunning(String cacheName) {
        return this.container.isRunning(this.getCacheName(cacheName));
    }

    public boolean isDefaultRunning() {
        return this.container.isRunning(this.defaultCache);
    }

    public boolean cacheExists(String cacheName) {
        return this.container.cacheExists(this.getCacheName(cacheName));
    }

    public void removeCache(String cacheName) {
        this.container.removeCache(this.getCacheName(cacheName));
    }

    private String getCacheName(String name) {
        return name == null || name.equals("___defaultcache") ? this.defaultCache : name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.container.getGlobalConfiguration().getCacheManagerName();
    }

    class DelegatingCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        private final AdvancedCache<K, V> cache;

        DelegatingCache(AdvancedCache<K, V> cache) {
            super(cache);
            this.cache = cache;
        }

        DelegatingCache(Cache<K, V> cache) {
            this(cache.getAdvancedCache());
        }

        public EmbeddedCacheManager getCacheManager() {
            return DefaultEmbeddedCacheManager.this;
        }

        public AdvancedCache<K, V> getAdvancedCache() {
            return this;
        }

        public AdvancedCache<K, V> with(ClassLoader classLoader) {
            return new ClassLoaderAwareCache(this, classLoader);
        }

        public boolean equals(Object object) {
            return object == this || object == this.cache;
        }

        public int hashCode() {
            return this.cache.hashCode();
        }
    }
}

