/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.infinispan.configuration.cache.CacheMode;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.clustering.infinispan.subsystem.Namespace;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class InfinispanSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final XMLElementWriter<SubsystemMarshallingContext> INSTANCE = new InfinispanSubsystemXMLWriter();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            writer.writeAttribute(Attribute.DEFAULT_CACHE_CONTAINER.getLocalName(), model.require("default-cache-container").asString());
            for (Property entry : model.get("cache-container").asPropertyList()) {
                String[] cacheTypes;
                String containerName = entry.getName();
                ModelNode container = entry.getValue();
                writer.writeStartElement(Element.CACHE_CONTAINER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), containerName);
                this.writeAliases(writer, Attribute.ALIASES, container, "aliases");
                this.writeOptional(writer, Attribute.DEFAULT_CACHE, container, "default-cache");
                this.writeOptional(writer, Attribute.EVICTION_EXECUTOR, container, "eviction-executor");
                this.writeOptional(writer, Attribute.JNDI_NAME, container, "jndi-name");
                this.writeOptional(writer, Attribute.LISTENER_EXECUTOR, container, "listener-executor");
                this.writeOptional(writer, Attribute.REPLICATION_QUEUE_EXECUTOR, container, "replication-queue-executor");
                this.writeOptional(writer, Attribute.START, container, "start");
                if (container.hasDefined("transport")) {
                    writer.writeStartElement(Element.TRANSPORT.getLocalName());
                    ModelNode transport = container.get(new String[]{"transport", "TRANSPORT"});
                    this.writeOptional(writer, Attribute.STACK, transport, "stack");
                    this.writeOptional(writer, Attribute.CLUSTER, transport, "cluster");
                    this.writeOptional(writer, Attribute.EXECUTOR, transport, "executor");
                    this.writeOptional(writer, Attribute.LOCK_TIMEOUT, transport, "lock-timeout");
                    this.writeOptional(writer, Attribute.SITE, transport, "site");
                    this.writeOptional(writer, Attribute.RACK, transport, "rack");
                    this.writeOptional(writer, Attribute.MACHINE, transport, "machine");
                    writer.writeEndElement();
                }
                ArrayList<Property> cachesPL = new ArrayList<Property>();
                for (String cacheType : cacheTypes = new String[]{"local-cache", "invalidation-cache", "replicated-cache", "distributed-cache"}) {
                    List<Property> cachesOfAType = InfinispanSubsystemXMLWriter.getCachesAsPropertyList(model, containerName, cacheType);
                    if (cachesOfAType == null) continue;
                    cachesPL.addAll(cachesOfAType);
                }
                ArrayList<ModelNode> caches = new ArrayList<ModelNode>();
                for (Property cacheEntry : cachesPL) {
                    caches.add(cacheEntry.getValue());
                }
                for (ModelNode cache : caches) {
                    ModelNode store;
                    CacheMode mode = CacheMode.valueOf((String)cache.get("mode").asString());
                    if (mode.isClustered()) {
                        if (mode.isDistributed()) {
                            writer.writeStartElement(Element.DISTRIBUTED_CACHE.getLocalName());
                            this.writeRequired(writer, Attribute.NAME, cache, "name");
                            this.writeOptional(writer, Attribute.OWNERS, cache, "owners");
                            this.writeOptional(writer, Attribute.VIRTUAL_NODES, cache, "virtual-nodes");
                            this.writeOptional(writer, Attribute.L1_LIFESPAN, cache, "l1-lifespan");
                        } else if (mode.isInvalidation()) {
                            writer.writeStartElement(Element.INVALIDATION_CACHE.getLocalName());
                            this.writeRequired(writer, Attribute.NAME, cache, "name");
                        } else {
                            writer.writeStartElement(Element.REPLICATED_CACHE.getLocalName());
                            this.writeRequired(writer, Attribute.NAME, cache, "name");
                        }
                        this.writeOptional(writer, Attribute.ASYNC_MARSHALLING, cache, "async-marshalling");
                        writer.writeAttribute(Attribute.MODE.getLocalName(), Mode.forCacheMode(mode).name());
                        this.writeOptional(writer, Attribute.QUEUE_SIZE, cache, "queue-size");
                        this.writeOptional(writer, Attribute.QUEUE_FLUSH_INTERVAL, cache, "queue-flush-interval");
                        this.writeOptional(writer, Attribute.REMOTE_TIMEOUT, cache, "remote-timeout");
                    } else {
                        writer.writeStartElement(Element.LOCAL_CACHE.getLocalName());
                        this.writeRequired(writer, Attribute.NAME, cache, "name");
                    }
                    this.writeOptional(writer, Attribute.START, cache, "start");
                    this.writeOptional(writer, Attribute.BATCHING, cache, "batching");
                    this.writeOptional(writer, Attribute.INDEXING, cache, "indexing");
                    this.writeOptional(writer, Attribute.JNDI_NAME, cache, "jndi-name");
                    if (cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
                        writer.writeStartElement(Element.LOCKING.getLocalName());
                        ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
                        this.writeOptional(writer, Attribute.ISOLATION, locking, "isolation");
                        this.writeOptional(writer, Attribute.STRIPING, locking, "striping");
                        this.writeOptional(writer, Attribute.ACQUIRE_TIMEOUT, locking, "acquire-timeout");
                        this.writeOptional(writer, Attribute.CONCURRENCY_LEVEL, locking, "concurrency-level");
                        writer.writeEndElement();
                    }
                    if (cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
                        writer.writeStartElement(Element.TRANSACTION.getLocalName());
                        ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
                        this.writeOptional(writer, Attribute.STOP_TIMEOUT, transaction, "stop-timeout");
                        this.writeOptional(writer, Attribute.MODE, transaction, "mode");
                        this.writeOptional(writer, Attribute.LOCKING, transaction, "locking");
                        writer.writeEndElement();
                    }
                    if (cache.get(new String[]{"eviction", "EVICTION"}).isDefined()) {
                        writer.writeStartElement(Element.EVICTION.getLocalName());
                        ModelNode eviction = cache.get(new String[]{"eviction", "EVICTION"});
                        this.writeOptional(writer, Attribute.STRATEGY, eviction, "strategy");
                        this.writeOptional(writer, Attribute.MAX_ENTRIES, eviction, "max-entries");
                        writer.writeEndElement();
                    }
                    if (cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
                        writer.writeStartElement(Element.EXPIRATION.getLocalName());
                        ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
                        this.writeOptional(writer, Attribute.MAX_IDLE, expiration, "max-idle");
                        this.writeOptional(writer, Attribute.LIFESPAN, expiration, "lifespan");
                        this.writeOptional(writer, Attribute.INTERVAL, expiration, "interval");
                        writer.writeEndElement();
                    }
                    if (cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
                        ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
                        writer.writeStartElement(Element.STATE_TRANSFER.getLocalName());
                        this.writeOptional(writer, Attribute.ENABLED, stateTransfer, "enabled");
                        this.writeOptional(writer, Attribute.TIMEOUT, stateTransfer, "timeout");
                        this.writeOptional(writer, Attribute.CHUNK_SIZE, stateTransfer, "chunk-size");
                        writer.writeEndElement();
                    }
                    if (cache.get(new String[]{"store", "STORE"}).isDefined()) {
                        store = cache.get(new String[]{"store", "STORE"});
                        writer.writeStartElement(Element.STORE.getLocalName());
                        this.writeRequired(writer, Attribute.CLASS, store, "class");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreWriteBehind(writer, store);
                        this.writeStoreProperties(writer, store);
                        writer.writeEndElement();
                    } else if (cache.get(new String[]{"file-store", "FILE_STORE"}).isDefined()) {
                        store = cache.get(new String[]{"file-store", "FILE_STORE"});
                        writer.writeStartElement(Element.FILE_STORE.getLocalName());
                        this.writeOptional(writer, Attribute.RELATIVE_TO, store, "relative-to");
                        this.writeOptional(writer, Attribute.PATH, store, "path");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreWriteBehind(writer, store);
                        this.writeStoreProperties(writer, store);
                        writer.writeEndElement();
                    } else if (cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"}).isDefined()) {
                        store = cache.get(new String[]{"string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE"});
                        writer.writeStartElement(Element.STRING_KEYED_JDBC_STORE.getLocalName());
                        this.writeRequired(writer, Attribute.DATASOURCE, store, "datasource");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreWriteBehind(writer, store);
                        this.writeStoreProperties(writer, store);
                        this.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
                        writer.writeEndElement();
                    } else if (cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"}).isDefined()) {
                        store = cache.get(new String[]{"binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE"});
                        writer.writeStartElement(Element.BINARY_KEYED_JDBC_STORE.getLocalName());
                        this.writeRequired(writer, Attribute.DATASOURCE, store, "datasource");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreWriteBehind(writer, store);
                        this.writeStoreProperties(writer, store);
                        this.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
                        writer.writeEndElement();
                    } else if (cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"}).isDefined()) {
                        store = cache.get(new String[]{"mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE"});
                        writer.writeStartElement(Element.MIXED_KEYED_JDBC_STORE.getLocalName());
                        this.writeRequired(writer, Attribute.DATASOURCE, store, "datasource");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreWriteBehind(writer, store);
                        this.writeStoreProperties(writer, store);
                        this.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, store, "string-keyed-table");
                        this.writeJDBCStoreTable(writer, Element.BINARY_KEYED_TABLE, store, "binary-keyed-table");
                        writer.writeEndElement();
                    } else if (cache.get(new String[]{"remote-store", "REMOTE_STORE"}).isDefined()) {
                        store = cache.get(new String[]{"remote-store", "REMOTE_STORE"});
                        writer.writeStartElement(Element.REMOTE_STORE.getLocalName());
                        this.writeOptional(writer, Attribute.CACHE, store, "cache");
                        this.writeOptional(writer, Attribute.SOCKET_TIMEOUT, store, "socket-timeout");
                        this.writeOptional(writer, Attribute.TCP_NO_DELAY, store, "tcp-no-delay");
                        this.writeStoreAttributes(writer, store);
                        this.writeStoreWriteBehind(writer, store);
                        this.writeStoreProperties(writer, store);
                        for (ModelNode remoteServer : store.get("remote-servers").asList()) {
                            writer.writeStartElement(Element.REMOTE_SERVER.getLocalName());
                            writer.writeAttribute(Attribute.OUTBOUND_SOCKET_BINDING.getLocalName(), remoteServer.get("outbound-socket-binding").asString());
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public static List<Property> getCachesAsPropertyList(ModelNode model, String containerName, String cacheType) {
        ModelNode caches = model.get(new String[]{"cache-container", containerName, cacheType});
        if (caches.isDefined() && caches.getType() == ModelType.OBJECT) {
            return caches.asPropertyList();
        }
        return null;
    }

    private void writeAliases(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode container, String key) throws XMLStreamException {
        if (container.hasDefined(key)) {
            StringBuffer result = new StringBuffer();
            ModelNode aliases = container.get(key);
            if (aliases.isDefined() && aliases.getType() == ModelType.LIST) {
                List aliasesList = aliases.asList();
                for (int i = 0; i < aliasesList.size(); ++i) {
                    result.append(((ModelNode)aliasesList.get(i)).asString());
                    if (i >= aliasesList.size() - 1) continue;
                    result.append(" ");
                }
                writer.writeAttribute(attribute.getLocalName(), result.toString());
            }
        }
    }

    private void writeJDBCStoreTable(XMLExtendedStreamWriter writer, Element element, ModelNode store, String key) throws XMLStreamException {
        if (store.hasDefined(key)) {
            ModelNode table = store.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.PREFIX, table, "prefix");
            this.writeOptional(writer, Attribute.BATCH_SIZE, table, "batch-size");
            this.writeOptional(writer, Attribute.FETCH_SIZE, table, "fetch-size");
            this.writeJDBCStoreColumn(writer, Element.ID_COLUMN, table, "id-column");
            this.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, table, "data-column");
            this.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, table, "timestamp-column");
            writer.writeEndElement();
        }
    }

    private void writeJDBCStoreColumn(XMLExtendedStreamWriter writer, Element element, ModelNode table, String key) throws XMLStreamException {
        if (table.hasDefined(key)) {
            ModelNode column = table.get(key);
            writer.writeStartElement(element.getLocalName());
            this.writeOptional(writer, Attribute.NAME, column, "name");
            this.writeOptional(writer, Attribute.TYPE, column, "type");
            writer.writeEndElement();
        }
    }

    private void writeStoreAttributes(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        this.writeOptional(writer, Attribute.SHARED, store, "shared");
        this.writeOptional(writer, Attribute.PRELOAD, store, "preload");
        this.writeOptional(writer, Attribute.PASSIVATION, store, "passivation");
        this.writeOptional(writer, Attribute.FETCH_STATE, store, "fetch-state");
        this.writeOptional(writer, Attribute.PURGE, store, "purge");
        this.writeOptional(writer, Attribute.SINGLETON, store, "singleton");
    }

    private void writeStoreWriteBehind(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined()) {
            ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
            writer.writeStartElement(Element.WRITE_BEHIND.getLocalName());
            this.writeOptional(writer, Attribute.FLUSH_LOCK_TIMEOUT, writeBehind, "flush-lock-timeout");
            this.writeOptional(writer, Attribute.MODIFICATION_QUEUE_SIZE, writeBehind, "modification-queue-size");
            this.writeOptional(writer, Attribute.SHUTDOWN_TIMEOUT, writeBehind, "shutdown-timeout");
            this.writeOptional(writer, Attribute.THREAD_POOL_SIZE, writeBehind, "thread-pool-size");
            writer.writeEndElement();
        }
    }

    private void writeStoreProperties(XMLExtendedStreamWriter writer, ModelNode store) throws XMLStreamException {
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private void writeOptional(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        if (model.hasDefined(key)) {
            writer.writeAttribute(attribute.getLocalName(), model.get(key).asString());
        }
    }

    private void writeRequired(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), model.require(key).asString());
    }
}

