/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.management.MBeanServer;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.LocalDescriptions;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.threads.JBossExecutors;

public class ProtocolStackAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        ProtocolStackAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("transport").set(source.require("transport"));
        ModelNode protocols = target.get("protocol");
        for (ModelNode protocol : source.require("protocol").asList()) {
            protocols.add(protocol);
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getProtocolStackAddDescription(locale);
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode removeOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ProtocolStackAdd.populate(operation, context.getSubModel());
        RuntimeOperationContext runtime = context.getRuntimeContext();
        if (runtime != null) {
            RuntimeTask task = new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ModelNode transport = operation.get("transport");
                    Transport transportConfig = new Transport(transport.require("type").asString());
                    ProtocolStack stackConfig = new ProtocolStack(name, transportConfig);
                    ServiceBuilder builder = context.getServiceTarget().addService(ChannelFactoryService.getServiceName(name), (Service)new ValueService((Value)new ImmediateValue((Object)new JChannelFactory(stackConfig)))).addDependency(ProtocolDefaultsService.SERVICE_NAME, ProtocolDefaults.class, stackConfig.getDefaultsInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, stackConfig.getMBeanServerInjector());
                    this.build((ServiceBuilder<ChannelFactory>)builder, transport, transportConfig);
                    this.addSocketBindingDependency((ServiceBuilder<ChannelFactory>)builder, transport, "diagnostics-socket-binding", transportConfig.getDiagnosticsSocketBindingInjector());
                    this.addExecutorDependency((ServiceBuilder<ChannelFactory>)builder, transport, "default-executor", transportConfig.getDefaultExecutorInjector());
                    this.addExecutorDependency((ServiceBuilder<ChannelFactory>)builder, transport, "oob-executor", transportConfig.getOOBExecutorInjector());
                    if (transport.hasDefined("timer-executor")) {
                        builder.addDependency(ThreadsServices.executorName((String)transport.get("timer-executor").asString()), ScheduledExecutorService.class, transportConfig.getTimerExecutorInjector());
                    }
                    if (transport.hasDefined("thread-factory")) {
                        builder.addDependency(ThreadsServices.threadFactoryName((String)transport.get("thread-factory").asString()), ThreadFactory.class, transportConfig.getThreadFactoryInjector());
                    }
                    for (ModelNode protocol : operation.get("protocol").asList()) {
                        Protocol protocolConfig = new Protocol(protocol.require("type").asString());
                        this.build((ServiceBuilder<ChannelFactory>)builder, protocol, protocolConfig);
                        stackConfig.getProtocols().add(protocolConfig);
                    }
                    builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                    resultHandler.handleResultComplete();
                }

                private void build(ServiceBuilder<ChannelFactory> builder, ModelNode protocol, Protocol protocolConfig) {
                    this.addSocketBindingDependency(builder, protocol, "socket-binding", protocolConfig.getSocketBindingInjector());
                    Map<String, String> properties = protocolConfig.getProperties();
                    if (protocol.hasDefined("property")) {
                        for (Property property : protocol.get("property").asPropertyList()) {
                            properties.put(property.getName(), property.getValue().asString());
                        }
                    }
                }

                private void addSocketBindingDependency(ServiceBuilder<ChannelFactory> builder, ModelNode model, String key, Injector<SocketBinding> injector) {
                    if (model.hasDefined(key)) {
                        builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get(key).asString()}), SocketBinding.class, injector);
                    }
                }

                private void addExecutorDependency(ServiceBuilder<ChannelFactory> builder, ModelNode model, String key, Injector<Executor> injector) {
                    if (model.hasDefined(key)) {
                        builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), Executor.class, injector);
                    }
                }
            };
            runtime.setRuntimeTask(task);
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(removeOperation);
    }

    static class Protocol
    implements ProtocolConfiguration {
        private final String name;
        private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
        private final Map<String, String> properties = new HashMap<String, String>();

        Protocol(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties;
        }

        Injector<SocketBinding> getSocketBindingInjector() {
            return this.socketBinding;
        }

        @Override
        public SocketBinding getSocketBinding() {
            return (SocketBinding)this.socketBinding.getOptionalValue();
        }
    }

    static class Transport
    extends Protocol
    implements TransportConfiguration {
        private final InjectedValue<SocketBinding> diagnosticsSocketBinding = new InjectedValue();
        private final InjectedValue<Executor> defaultExecutor = new InjectedValue();
        private final InjectedValue<Executor> oobExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> timerExecutor = new InjectedValue();
        private final InjectedValue<ThreadFactory> threadFactory = new InjectedValue();
        private boolean shared = true;

        Transport(String name) {
            super(name);
        }

        Injector<SocketBinding> getDiagnosticsSocketBindingInjector() {
            return this.diagnosticsSocketBinding;
        }

        Injector<Executor> getDefaultExecutorInjector() {
            return this.defaultExecutor;
        }

        Injector<Executor> getOOBExecutorInjector() {
            return this.oobExecutor;
        }

        Injector<ScheduledExecutorService> getTimerExecutorInjector() {
            return this.timerExecutor;
        }

        Injector<ThreadFactory> getThreadFactoryInjector() {
            return this.threadFactory;
        }

        void setShared(boolean shared) {
            this.shared = shared;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        @Override
        public SocketBinding getDiagnosticsSocketBinding() {
            return (SocketBinding)this.diagnosticsSocketBinding.getOptionalValue();
        }

        @Override
        public ExecutorService getDefaultExecutor() {
            Executor executor = (Executor)this.defaultExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ExecutorService getOOBExecutor() {
            Executor executor = (Executor)this.oobExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ScheduledExecutorService getTimerExecutor() {
            return (ScheduledExecutorService)this.timerExecutor.getOptionalValue();
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return (ThreadFactory)this.threadFactory.getOptionalValue();
        }
    }

    static class ProtocolStack
    implements ProtocolStackConfiguration {
        private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final String name;
        private final TransportConfiguration transport;
        private final List<ProtocolConfiguration> protocols = new LinkedList<ProtocolConfiguration>();

        ProtocolStack(String name, TransportConfiguration transport) {
            this.name = name;
            this.transport = transport;
        }

        Injector<ProtocolDefaults> getDefaultsInjector() {
            return this.defaults;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        @Override
        public TransportConfiguration getTransport() {
            return this.transport;
        }

        @Override
        public List<ProtocolConfiguration> getProtocols() {
            return this.protocols;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ProtocolDefaults getDefaults() {
            return (ProtocolDefaults)this.defaults.getValue();
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }
    }
}

