/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.deployment;

import java.io.File;
import java.net.URL;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class ResourceAdapterXmlDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.deployment.connector");
    private final Module module;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private final String deploymentName;
    private final File root;
    private final ResourceAdapter raxml;
    private final Connector cmd;
    private final IronJacamar ijmd;

    public ResourceAdapterXmlDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, ResourceAdapter raxml, Connector cmd, IronJacamar ijmd, Module module, String deploymentName, File root) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        this.raxml = raxml;
        this.cmd = cmd;
        this.ijmd = ijmd;
        this.module = module;
        this.deploymentName = deploymentName;
        this.root = root;
    }

    public void start(StartContext context) throws StartException {
        log.debugf("Starting sevice %s", (Object)ConnectorServices.RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
        ServiceContainer container = context.getController().getServiceContainer();
        AS7RaXmlDeployer raDeployer = new AS7RaXmlDeployer(container, this.connectorXmlDescriptor.getUrl(), this.deploymentName, this.root, (ClassLoader)this.module.getClassLoader(), this.cmd, this.raxml);
        raDeployer.setConfiguration((Configuration)this.config.getValue());
        CommonDeployment raxmlDeployment = null;
        try {
            raxmlDeployment = raDeployer.doDeploy();
        }
        catch (Throwable t) {
            throw new StartException("Failed to start RA deployment [" + this.deploymentName + "]", t);
        }
        this.value = new ResourceAdapterDeployment(raxmlDeployment);
        ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
        ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
    }

    @Override
    public void stop(StopContext context) {
        log.debugf("Stopping sevice %s", (Object)ConnectorServices.RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
        ((ManagementRepository)this.managementRepository.getValue()).getConnectors().remove(this.value.getDeployment().getConnector());
        super.stop(context);
    }

    private class AS7RaXmlDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractAS7RaDeployer {
        private final ResourceAdapter ra;

        public AS7RaXmlDeployer(ServiceContainer serviceContainer, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, ResourceAdapter ra) {
            super(serviceContainer, url, deploymentName, root, cl, cmd);
            this.ra = ra;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterXmlDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, ResourceAdapterXmlDeploymentService.this.ijmd, this.ra);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            return true;
        }
    }
}

