/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.pool;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

public class PoolConfigurationRWHandler {
    static final String[] NO_LOCATION = new String[0];
    public static final String[] ATTRIBUTES = new String[]{"max-pool-size", "min-pool-size", "blocking-timeout-wait-millis", "idle-timeout-minutes", "background-validation", "background-validation-minutes", "pool-prefill", "pool-use-strict-min", "use-fast-fail"};

    static class PoolConfigurationValidator
    implements ParameterValidator {
        static final ModelTypeValidator intValidator = new ModelTypeValidator(ModelType.INT);
        static final ModelTypeValidator longValidator = new ModelTypeValidator(ModelType.LONG);
        static final ModelTypeValidator boolValidator = new ModelTypeValidator(ModelType.BOOLEAN);

        PoolConfigurationValidator() {
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if ("max-pool-size".equals(parameterName)) {
                intValidator.validateParameter(parameterName, value);
            } else if ("min-pool-size".equals(parameterName)) {
                intValidator.validateParameter(parameterName, value);
            } else if ("blocking-timeout-wait-millis".equals(parameterName)) {
                longValidator.validateParameter(parameterName, value);
            } else if ("idle-timeout-minutes".equals(parameterName)) {
                longValidator.validateParameter(parameterName, value);
            } else if ("background-validation".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else if ("background-validation-minutes".equals(parameterName)) {
                intValidator.validateParameter(parameterName, value);
            } else if ("pool-prefill".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else if ("pool-use-strict-min".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else if ("use-fast-fail".equals(parameterName)) {
                boolValidator.validateParameter(parameterName, value);
            } else {
                throw new OperationFailedException(new ModelNode().set("Wrong parameter name for " + parameterName));
            }
        }

        public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
            this.validateParameter(parameterName, value.resolve());
        }
    }

    public static class RaPoolConfigurationWriteHandler
    extends PoolConfigurationWriteHandler {
        public static RaPoolConfigurationWriteHandler INSTANCE = new RaPoolConfigurationWriteHandler(new PoolConfigurationValidator());

        protected RaPoolConfigurationWriteHandler(ParameterValidator validator) {
            super(validator);
        }

        @Override
        protected List<PoolConfiguration> getMatchingPoolConfigs(String jndiName, ManagementRepository repository) {
            ArrayList<PoolConfiguration> result = new ArrayList<PoolConfiguration>(repository.getConnectors().size());
            if (repository.getConnectors() != null) {
                for (Connector conn : repository.getConnectors()) {
                    if (!jndiName.equalsIgnoreCase(conn.getUniqueId()) || conn.getConnectionFactories() == null || conn.getConnectionFactories().get(0) == null) continue;
                    PoolConfiguration pc = ((ConnectionFactory)conn.getConnectionFactories().get(0)).getPoolConfiguration();
                    result.add(pc);
                }
            }
            result.trimToSize();
            return result;
        }
    }

    public static class LocalAndXaDataSourcePoolConfigurationWriteHandler
    extends PoolConfigurationWriteHandler {
        public static LocalAndXaDataSourcePoolConfigurationWriteHandler INSTANCE = new LocalAndXaDataSourcePoolConfigurationWriteHandler(new PoolConfigurationValidator());

        protected LocalAndXaDataSourcePoolConfigurationWriteHandler(ParameterValidator validator) {
            super(validator);
        }

        @Override
        protected List<PoolConfiguration> getMatchingPoolConfigs(String jndiName, ManagementRepository repository) {
            ArrayList<PoolConfiguration> result = new ArrayList<PoolConfiguration>(repository.getDataSources().size());
            if (repository.getDataSources() != null) {
                for (DataSource ds : repository.getDataSources()) {
                    if (!jndiName.equalsIgnoreCase(ds.getJndiName())) continue;
                    result.add(ds.getPoolConfiguration());
                }
            }
            result.trimToSize();
            return result;
        }
    }

    public static abstract class PoolConfigurationWriteHandler
    extends ServerWriteAttributeOperationHandler {
        protected PoolConfigurationWriteHandler(ParameterValidator validator) {
            super(validator);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, final ModelNode operation, final ResultHandler resultHandler, final String parameterName, final ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
            if (context.getRuntimeContext() != null) {
                context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                    public void execute(RuntimeTaskContext runtimeCtx) throws OperationFailedException {
                        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                        String jndiName = address.getLastElement().getValue();
                        ServiceController managementRepoService = runtimeCtx.getServiceRegistry().getService(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE);
                        if (managementRepoService != null) {
                            try {
                                ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                                List<PoolConfiguration> poolConfigs = PoolConfigurationWriteHandler.this.getMatchingPoolConfigs(jndiName, repository);
                                for (PoolConfiguration pc : poolConfigs) {
                                    if ("max-pool-size".equals(parameterName)) {
                                        pc.setMaxSize(newValue.asInt());
                                    }
                                    if ("min-pool-size".equals(parameterName)) {
                                        pc.setMinSize(newValue.asInt());
                                    }
                                    if ("blocking-timeout-wait-millis".equals(parameterName)) {
                                        pc.setBlockingTimeout(newValue.asLong());
                                    }
                                    if ("pool-use-strict-min".equals(parameterName)) {
                                        pc.setStrictMin(newValue.asBoolean());
                                    }
                                    if (!"use-fast-fail".equals(parameterName)) continue;
                                    pc.setUseFastFail(newValue.asBoolean());
                                }
                                resultHandler.handleResultComplete();
                            }
                            catch (Exception e) {
                                throw new OperationFailedException(new ModelNode().set("failed to set attribute" + e.getMessage()));
                            }
                        } else {
                            resultHandler.handleResultComplete();
                        }
                    }
                });
            } else {
                resultHandler.handleResultComplete();
            }
            return "idle-timeout-minutes".equals(parameterName) || "background-validation".equals(parameterName) || "background-validation-minutes".equals(parameterName) || "pool-prefill".equals(parameterName);
        }

        protected abstract List<PoolConfiguration> getMatchingPoolConfigs(String var1, ManagementRepository var2);
    }

    public static class PoolConfigurationReadHandler
    implements ModelQueryOperationHandler {
        public static PoolConfigurationReadHandler INSTANCE = new PoolConfigurationReadHandler();

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String jndiName = address.getLastElement().getValue();
            String parameterName = operation.require("name").asString();
            ModelNode submodel = context.getSubModel();
            ModelNode currentValue = submodel.get(parameterName).clone();
            resultHandler.handleResultFragment(new String[0], currentValue);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
    }
}

