/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.registry;

import org.jboss.modules.ModuleIdentifier;

public final class InstalledDriver {
    private final ModuleIdentifier moduleName;
    private final String deploymentUnitName;
    private final String driverClassName;
    private final int majorVersion;
    private final int minorVersion;
    private final boolean jdbcCompliant;

    public InstalledDriver(ModuleIdentifier moduleName, String driverClassName, int majorVersion, int minorVersion, boolean jdbcCompliant) {
        this.deploymentUnitName = null;
        this.moduleName = moduleName;
        this.driverClassName = driverClassName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.jdbcCompliant = jdbcCompliant;
    }

    public InstalledDriver(String deploymentUnitName, String driverClassName, int majorVersion, int minorVersion, boolean jdbcCompliant) {
        this.deploymentUnitName = deploymentUnitName;
        this.moduleName = null;
        this.driverClassName = driverClassName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.jdbcCompliant = jdbcCompliant;
    }

    public ModuleIdentifier getModuleName() {
        return this.moduleName;
    }

    public String getDeploymentUnitName() {
        return this.deploymentUnitName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public boolean isFromDeployment() {
        return this.deploymentUnitName != null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.driverClassName.hashCode();
        result = 37 * result + this.majorVersion;
        result = 37 * result + this.minorVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof InstalledDriver) {
            InstalledDriver other = (InstalledDriver)obj;
            return this.driverClassName.equals(other.driverClassName) && this.majorVersion == other.majorVersion && this.minorVersion == other.minorVersion;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.moduleName != null) {
            sb.append(this.moduleName);
        } else {
            sb.append(this.deploymentUnitName);
        }
        sb.append(':');
        sb.append(this.driverClassName);
        sb.append('#');
        sb.append(this.majorVersion);
        sb.append('#');
        sb.append(this.minorVersion);
        return sb.toString();
    }
}

