/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.sql.Driver;
import javax.sql.DataSource;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.AttributeDefinition;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;
import org.jboss.util.Strings;

public abstract class AbstractDataSourceAdd
implements ModelAddOperationHandler {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode subModel = context.getSubModel();
        this.populateModel(operation, subModel);
        ModelNode address = operation.require("address");
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)address);
        String rawJndiName = operation.require("jndi-name").asString();
        final String jndiName = !rawJndiName.startsWith("java:/") && operation.hasDefined("use-java-context") && operation.get("use-java-context").asBoolean() ? "java:/" + rawJndiName : rawJndiName;
        final AbstractDataSourceService dataSourceService = this.createDataSourceService(jndiName, operation);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    boolean enabled = !operation.hasDefined("enabled") || operation.get("enabled").asBoolean();
                    ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                    ServiceBuilder dataSourceServiceBuilder = serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, dataSourceService.getmanagementRepositoryInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, dataSourceService.getSubjectFactoryInjector()).addDependency(NamingService.SERVICE_NAME);
                    String driverName = operation.require("driver").asString();
                    ServiceName driverServiceName = AbstractDataSourceAdd.this.getDriverDependency(driverName);
                    if (driverServiceName != null) {
                        dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
                    }
                    DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
                    ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                    ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
                    BinderService binderService = new BinderService(jndiName.substring(6));
                    ServiceName binderServiceName = ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName});
                    ServiceBuilder binderBuilder = serviceTarget.addService(binderServiceName, (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

                        public void serviceStarted(ServiceController<?> controller) {
                            log.infof("Bound data source [%s]", (Object)jndiName);
                        }

                        public void serviceStopped(ServiceController<?> serviceController) {
                            log.infof("Unbound data source [%s]", (Object)jndiName);
                        }

                        public void serviceRemoved(ServiceController<?> serviceController) {
                            log.debugf("Removed JDBC Data-source [%s]", (Object)jndiName);
                            serviceController.removeListener((ServiceListener)this);
                        }
                    });
                    if (enabled) {
                        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
                    } else {
                        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.NEVER).install();
                        referenceBuilder.setInitialMode(ServiceController.Mode.NEVER).install();
                        binderBuilder.setInitialMode(ServiceController.Mode.NEVER).install();
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }

    protected abstract void populateModel(ModelNode var1, ModelNode var2);

    protected abstract AbstractDataSourceService createDataSourceService(String var1, ModelNode var2) throws OperationFailedException;

    private ServiceName getDriverDependency(String driver) {
        Integer minorVersion;
        Integer majorVersion;
        String[] strings = Strings.split((String)driver, (String)"#");
        if (strings.length != 2) {
            throw new IllegalArgumentException("module should define jdbc driver with this format: <driver-name>#<major-version>.<minor-version>");
        }
        String driverName = strings[0];
        if ((strings = Strings.split((String)strings[1], (String)".", (int)2)).length != 2) {
            throw new IllegalArgumentException("module should define jdbc driver with this format: <driver-name>#<major-version>.<minor-version>");
        }
        try {
            majorVersion = Integer.valueOf(strings[0]);
            minorVersion = Integer.valueOf(strings[1]);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("module should define jdbc driver with this format: <driver-name>#<major-version>.<minor-version> version number should be valid Integer");
        }
        if (driverName != null & majorVersion != null && minorVersion != null) {
            return ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName, Integer.toString(majorVersion), Integer.toString(minorVersion)});
        }
        return null;
    }

    static void populateAddModel(ModelNode existingModel, ModelNode newModel, String connectionPropertiesProp, AttributeDefinition[] attributes) {
        if (existingModel.has(connectionPropertiesProp)) {
            for (Property property : existingModel.get(connectionPropertiesProp).asPropertyList()) {
                newModel.get(new String[]{connectionPropertiesProp, property.getName()}).set(property.getValue().asString());
            }
        }
        for (AttributeDefinition attribute : attributes) {
            if (!existingModel.hasDefined(attribute.getName())) continue;
            newModel.get(attribute.getName()).set(existingModel.get(attribute.getName()));
        }
    }
}

