/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class DataSourceDisable
implements ModelUpdateOperationHandler {
    static final DataSourceDisable INSTANCE = new DataSourceDisable();
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.subsystems.datasources");

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("enable");
        compensatingOperation.get("address").set(opAddr);
        final String jndiName = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        context.getSubModel().get("enabled").set(false);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceName binderServiceName;
                    ServiceController binderController;
                    ServiceName dataSourceServiceName;
                    ServiceRegistry registry = context.getServiceRegistry();
                    ServiceController dataSourceController = registry.getService(dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName}));
                    if (dataSourceController != null) {
                        if (!ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                            throw new OperationFailedException(new ModelNode().set("Data-source service [" + jndiName + "] is not enabled"));
                        }
                    } else {
                        throw new OperationFailedException(new ModelNode().set("Data-source service [" + jndiName + "] is not available"));
                    }
                    dataSourceController.setMode(ServiceController.Mode.NEVER);
                    dataSourceController.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                        public void serviceStopped(ServiceController<?> serviceController) {
                            resultHandler.handleResultComplete();
                            serviceController.removeListener((ServiceListener)this);
                        }
                    });
                    ServiceName referenceServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName});
                    ServiceController referenceController = registry.getService(referenceServiceName);
                    if (referenceController != null && ServiceController.State.UP.equals((Object)referenceController.getState())) {
                        referenceController.setMode(ServiceController.Mode.NEVER);
                    }
                    if ((binderController = registry.getService(binderServiceName = ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName}))) != null && ServiceController.State.UP.equals((Object)binderController.getState())) {
                        binderController.setMode(ServiceController.Mode.NEVER);
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

