/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.subsystems.resourceadapters.AbstractRaOperation;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersService;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class RaRemove
extends AbstractRaOperation
implements ModelRemoveOperationHandler {
    static final RaRemove INSTANCE = new RaRemove();

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        String archive = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        operation.get("archive").set(archive);
        ModelNode model = context.getSubModel();
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("resource-adapters")) {
            for (ModelNode raNode : model.get("resource-adapters").asList()) {
                ModelNode raCompensatingNode = raNode.clone();
                compensating.get("resource-adapters").add(raCompensatingNode);
            }
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ResourceAdaptersService.ModifiableResourceAdapeters resourceAdapters = RaRemove.this.buildResourceAdaptersObject(operation);
                    ServiceController raService = context.getServiceRegistry().getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
                    if (raService != null) {
                        ((ResourceAdaptersService.ModifiableResourceAdapeters)raService.getValue()).removeAllResourceAdapters(resourceAdapters.getResourceAdapters());
                    }
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

